/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor;

import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsMessageSendContext;
import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsSendResult;

/**
 * 拦截器执行器
 *
 * @author liluqing
 * @version InterceptorExecuter.java, v 0.1 2021-10-26 22:02
 */
public interface ProducerInterceptorActuator {

    /**
     * 消息发送之前,如抛出异常会终止发送
     *
     * @param context
     */
    void doBeforeSend(FsMessageSendContext context);

    /**
     * 消息发送之后
     *
     * @param context
     * @param result
     */
    void doAfterSend(FsMessageSendContext context, FsSendResult result);
}