/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.interceptor;

import com.fshows.ark.spring.boot.starter.core.mq.base.producer.FsProducerInterceptor;

import java.util.List;

/**
 * 生产者拦截管理器
 *
 * @author liluqing
 * @version ProducerInterceptorManagement.java, v 0.1 2021-10-26 20:41
 */
public interface IProducerInterceptorManagement {

    /**
     * 注册一个拦截器
     */
    void registerInterceptor(FsProducerInterceptor fsProducerInterceptor);

    /**
     * 获取所有的已注册的拦截器
     *
     * @return
     */
    List<FsProducerInterceptor> getAllInterceptor();

    /**
     * 获取拦截器执行器，通过该执行器可执行拦截器链方法
     *
     * @return
     */
    ProducerInterceptorActuator getProducerInterceptorActuator();
}