/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer;

import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.PropertyKeyConst;
import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModelProperties;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.IFshowsConsumer;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

/**
 *
 * @author liluqing
 * @version DefaultConsumeContainerImpl.java, v 0.1 2021-09-27 17:49
 */
public class DefaultConsumeContainerImpl extends AbstractConsumerContainer {

    /**
     * 消费者容器,用于存放消费者bean
     */
    private ConcurrentHashMap<String, ConsumerBean> consumeMap = new ConcurrentHashMap<String, ConsumerBean>(16);

    @Override
    protected IFshowsConsumer doCreateIFshowsConsumer(FsConsumerModel consumerModel) {
        FsConsumerModelProperties fsConsumerModelProperties = consumerModel.getConsumerProperties();
        ConsumerBean consumerBean = consumeMap.get(consumerModel.getConsumerProperties().getGroupId());
        if (consumerBean != null) {
            return new AliyunFshowsConsumerImpl(consumerBean, consumerModel);
        }
        consumerBean = new ConsumerBean();
        Properties properties = new Properties();
        properties.setProperty(PropertyKeyConst.GROUP_ID, fsConsumerModelProperties.getGroupId());
        properties.setProperty(PropertyKeyConst.AccessKey, fsConsumerModelProperties.getAccessKey());
        properties.setProperty(PropertyKeyConst.SecretKey, fsConsumerModelProperties.getSecretKey());
        properties.setProperty(PropertyKeyConst.NAMESRV_ADDR, fsConsumerModelProperties.getNamesrvAddr());

        //重试次数
        properties.setProperty(PropertyKeyConst.MaxReconsumeTimes, fsConsumerModelProperties.getMaxReconsumeTimes());
        //消费者数量
        properties.setProperty(PropertyKeyConst.ConsumeThreadNums, fsConsumerModelProperties.getConsumeThreadNums());
        // 消费超时时间
        properties.setProperty(PropertyKeyConst.ConsumeTimeout, fsConsumerModelProperties.getConsumeTimeout());

        consumerBean.setProperties(properties);
        // 缓存消费者
        bindSubscriptionMethod(consumerModel, consumerBean);
        consumeMap.put(consumerModel.getConsumerProperties().getGroupId(), consumerBean);
        return new AliyunFshowsConsumerImpl(consumerBean, consumerModel);
    }

    /**
     * 绑定订阅的方法
     *
     * @param fsConsumerModel
     * @param consumerBean
     */
    private void bindSubscriptionMethod(FsConsumerModel fsConsumerModel, ConsumerBean consumerBean) {
        FsConsumerModelProperties fsConsumerModelProperties = fsConsumerModel.getConsumerProperties();
        Map<Subscription, MessageListener> subscriptionTable = consumerBean.getSubscriptionTable() == null
                ? new HashMap() : consumerBean.getSubscriptionTable();
        // 设置订阅信息
        Subscription subscription = new Subscription();
        subscription.setTopic(fsConsumerModelProperties.getTopic());
        subscription.setExpression(fsConsumerModelProperties.getTags());
        // 通过代理类去消费消息
        subscriptionTable.put(subscription, new RocketListenerProxy(fsConsumerModel, super.consumerInterceptorManagement));
        consumerBean.setSubscriptionTable(subscriptionTable);
    }
}