/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.rocketmq.consumer;

import com.aliyun.openservices.ons.api.PropertyKeyConst;
import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModel;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsConsumerModelProperties;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.FsMessageListener;
import com.fshows.ark.spring.boot.starter.core.mq.base.consumer.IFshowsConsumer;
import lombok.extern.slf4j.Slf4j;

import java.util.Properties;

/**
 * 阿里云版consume实现
 *
 * @author liluqing
 * @version AliyunFshowsConsumerImpl.java, v 0.1 2021-09-27 17:57
 */
@Slf4j
public class AliyunFshowsConsumerImpl implements IFshowsConsumer {

    /**
     * 阿里云consumebean
     */
    private ConsumerBean consumerBean;

    /**
     * 消费者相关原信息
     */
    private FsConsumerModel fsConsumerModel;

    public AliyunFshowsConsumerImpl(ConsumerBean consumerBean, FsConsumerModel fsConsumerModel) {
        this.consumerBean = consumerBean;
        this.fsConsumerModel = fsConsumerModel;
    }

    @Override
    public void start() {
        consumerBean.start();
    }

    @Override
    public void shutdown() {
        consumerBean.shutdown();
    }

    @Override
    public void restart() {
        log.info("ark-spring-boot-starter >> 消费者实例“{}”开始重启！", fsConsumerModel.getConsumerProperties().getGroupId());
        // 如果消费者正在启动,则关闭消费者示例
        if (consumerBean.isStarted()) {
            consumerBean.shutdown();
        }
        // 重新加载消费者配置信息
        reloadConsumerConfig();
        // 重新启动消费者实例
        consumerBean.start();
        log.info("ark-spring-boot-starter >> 消费者实例“{}”重启完成！", fsConsumerModel.getConsumerProperties().getGroupId());
    }

    /**
     * 重新加载消费者配置信息
     */
    public void reloadConsumerConfig() {
        FsConsumerModelProperties fsConsumerModelProperties = fsConsumerModel.getConsumerProperties();
        Properties properties = consumerBean.getProperties();
        //重试次数
        properties.setProperty(PropertyKeyConst.MaxReconsumeTimes, fsConsumerModelProperties.getMaxReconsumeTimes());
        //消费者数量
        properties.setProperty(PropertyKeyConst.ConsumeThreadNums, fsConsumerModelProperties.getConsumeThreadNums());
        // 消费超时时间
        properties.setProperty(PropertyKeyConst.ConsumeTimeout, fsConsumerModelProperties.getConsumeTimeout());
        consumerBean.setProperties(properties);
        log.info("ark-spring-boot-starter >> 消费者实例“{}”配置刷新成功！刷新后的配置为：{}"
                , fsConsumerModelProperties.getGroupId(), properties);
    }

    @Override
    public void subscribe(String topic, String subExpression, FsMessageListener listener) {
        consumerBean.subscribe(topic, subExpression, new AliyunMessageListenerAdapter(listener, fsConsumerModel));
    }

    @Override
    public void setFsConsumerModelProperties(FsConsumerModelProperties consumerProperties) {
        fsConsumerModel.setConsumerProperties(consumerProperties);
    }

    @Override
    public FsConsumerModel getConsumerModel() {
        return fsConsumerModel;
    }
}