/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.base.producer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;

/**
 * 生产者拦截器接口
 *
 * @author liluqing
 * @version FsProducerInterceptor.java, v 0.1 2021-09-27 18:33
 */
public interface FsProducerInterceptor {

    /**
     * 消息发送之前,如抛出异常会终止发送
     *
     * @param context
     */
    void beforeSend(FsMessageSendContext context);

    /**
     * 消息发送之后
     *
     * @param context
     */
    void afterSend(FsMessageSendContext context, FsSendResult result);
}