/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.core.mq.base.producer;


import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;

/**
 * 自定义生产者
 *
 * @author Liluqing
 * @version FsProducer.java, v 0.1 2019-07-08 9:43
 */
public interface FsProducer {

    /**
     * 同步发送消息，只要不抛异常就表示成功
     *
     * @param message 要发送的消息对象
     * @return 发送结果，含消息Id, 消息主题
     */
    FsSendResult send(FsMessage message);

    /**
     * 同步发送消息，只要不抛异常就表示成功
     *
     * @param destination 消息目的地,格式'topic:tag'
     * @param msgKey 消息Key
     * @param content 消息主体
     * @return 发送结果，含消息Id, 消息主题
     */
    FsSendResult send(String destination, String msgKey, String content);

    /**
     * 同步发送消息，只要不抛异常就表示成功
     *
     * @param destination 消息目的地,格式'topic:tag'
     * @param msgKey 消息Key
     * @param content 消息主体
     * @param sendTime 消息主体
     * @return 发送结果，含消息Id, 消息主题
     */
    FsSendResult send(String destination, String msgKey, String content, long sendTime);

    /**
     * 发送消息，Oneway形式，服务器不应答，无法保证消息是否成功到达服务器
     *
     * @param message 要发送的消息
     */
    void sendOneway(FsMessage message);

    /**
     * 发送消息，Oneway形式，服务器不应答，无法保证消息是否成功到达服务器
     *
     * @param destination 消息目的地,格式'topic:tag'
     * @param msgKey 消息Key
     * @param content 消息主体
     */
    void sendOneway(String destination, String msgKey, String content);

    /**
     * 发送消息，异步Callback形式
     *
     * @param message 要发送的消息
     * @param sendCallback 发送完成要执行的回调函数
     */
    void sendAsync(FsMessage message, FsSendCallback sendCallback);

    /**
     * 异步发送消息，只要不抛异常就表示成功
     *
     * @param destination 消息目的地,格式'topic:tag'
     * @param msgKey 消息Key
     * @param content 消息主体
     * @return 发送结果，含消息Id, 消息主题
     */
    FsSendResult sendAsync(String destination, String msgKey, String content, FsSendCallback sendCallback);

    /**
     * 异步发送消息，只要不抛异常就表示成功
     *
     * @param destination 消息目的地,格式'topic:tag'
     * @param msgKey 消息Key
     * @param content 消息主体
     * @param sendTime 定时发送,
     * @return 发送结果，含消息Id, 消息主题
     */
    FsSendResult sendAsync(String destination, String msgKey, String content, FsSendCallback sendCallback, long sendTime);
}