/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.base.consumer;

/**
 * fs mq消费者接口
 *
 * @author liluqing
 * @version IFshowsConsumer.java, v 0.1 2021-09-09 19:54
 */
public interface IFshowsConsumer {

    /**
     * 启动服务
     */
    void start();

    /**
     * 关闭服务
     */
    void shutdown();

    /**
     * 重新下启动消费者服务
     */
    void restart();

    /**
     * 订阅消息
     *
     * @param topic
     *         消息主题
     * @param subExpression
     *         订阅过滤表达式字符串，ONS服务器依据此表达式进行过滤。只支持或运算<br>
     *         eg: "tag1 || tag2 || tag3"<br>
     *         如果subExpression等于null或者*，则表示全部订阅
     * @param listener
     *         消息回调监听器
     */
    void subscribe(String topic, String subExpression, FsMessageListener listener);

    /**
     * 设置消费者参数
     *
     * @param consumerProperties
     */
    void setFsConsumerModelProperties(FsConsumerModelProperties consumerProperties);

    /**
     * 获取消费者元数据
     */
    FsConsumerModel getConsumerModel();
}