/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package
        com.fshows.ark.spring.boot.starter.core.mq.base.consumer;

import com.fshows.ark.spring.boot.starter.core.mq.base.FsMessage;

/**
 * 消费者拦截器
 *
 * @author liluqing
 * @version FsConsumerInterceptor.java, v 0.1 2021-09-27 18:40
 */
public interface FsConsumerInterceptor {

    /**
     * 消息发送之前,如抛出异常会终止发送
     *
     * @param fsMessage
     */
    void beforeConsume(FsMessage fsMessage);

    /**
     * 消息发送之后
     *
     * @param fsMessage 消息内容
     * @param consumeResult 消费结果 true-消费成功/false-消费失败
     */
    void afterConsume(FsMessage fsMessage, boolean consumeResult);
}