/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.core.configservice.apollo;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.fshows.ark.spring.boot.starter.core.configservice.FsConfigChangeListener;
import com.fshows.ark.spring.boot.starter.util.ConfigUtil;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/**
 * 阿波罗配置变更监听器
 *
 * @author Liluqing
 * @version ConfigServicesListener.java, v 0.1 2019-10-08 16:15
 */
@ConditionalOnClass(ConfigService.class)
public class ConfigServicesListener implements ApplicationRunner {

    Map<String, List<FsConfigChangeListener>> listenerMap = new ConcurrentHashMap<>(10);

    public void addChangeListener(String keys, FsConfigChangeListener fsConfigChangeListener) {
        String[] keyArr = StringUtils.split(keys, ",");
        if (keyArr == null) {
            return;
        }
        for (String k : keyArr) {
            String realkey = ConfigUtil.getDynamicKey(k);
            List<FsConfigChangeListener> configChangeListenerList = listenerMap.get(realkey);
            if (configChangeListenerList == null) {
                configChangeListenerList = new CopyOnWriteArrayList<>();
                listenerMap.put(realkey, configChangeListenerList);
            }
            configChangeListenerList.add(fsConfigChangeListener);
        }
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        // 注册阿波罗监听
        Config config = ConfigService.getAppConfig();
        config.addChangeListener(changeEvent -> {
            for (String key : changeEvent.changedKeys()) {
                ConfigChange change = changeEvent.getChange(key);
                List<FsConfigChangeListener> listenerList = listenerMap.get(change.getPropertyName());
                if (listenerList == null || listenerList.size() == 0) {
                    continue;
                }
                for (FsConfigChangeListener changeListener : listenerList) {
                    try {
                        changeListener.onchange(change);
                    } catch (Exception e) {

                    }
                }
            }
        });
    }
}