/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.annotation.mq;

import com.fshows.ark.spring.boot.starter.constant.CommonConfigConstant;
import com.fshows.ark.spring.boot.starter.constant.MqConfigConstant;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 消费者函数标识
 *
 * @author Liluqing
 * @version RocketListener.java, v 0.1 2019-08-14 16:24
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD})
public @interface RocketListener {
    /**
     * 订阅的tag,允许订阅多个
     *
     * @return
     */
    String tags();

    /**
     * 消费者组ID
     *
     * @return
     */
    String groupId();

    /**
     * 授权key
     */
    String accessKey() default CommonConfigConstant.ALIYUN_ACCESS_KEY;

    /**
     * 密钥
     */
    String secretKey() default CommonConfigConstant.ALIYUN_SECRET_KEY;

    /**
     * mq nameSever地址
     */
    String namesrvAddr() default MqConfigConstant.NAME_SERVER_ADDR;

    /**
     * 消费线程数
     *
     * @return
     */
    String consumeThreadNums() default MqConfigConstant.CONSUME_DEFAULT_THREAD_NUM;

    /**
     * 最大消费重试次数
     *
     * @return
     */
    String maxReconsumeTimes() default MqConfigConstant.CONSUME_DEFAULT_MAX_RECONSUME_TIMES;

    /**
     * 消费超时时间（单位分钟）
     *
     * @return
     */
    String consumeTimeout() default MqConfigConstant.CONSUME_DEFAULT_TIMEOUT;

    /**
     * 消息内容的默认字符集编码
     */
    String msgContentCharset() default MqConfigConstant.PRODUCER_CONTENT_CHARSET;
}