/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.ark.spring.boot.starter.annotation.mq;

import com.fshows.ark.spring.boot.starter.extend.mq.interceptor.TraceIdConsumeInterceptor;
import com.fshows.ark.spring.boot.starter.extend.mq.interceptor.TraceIdProducerInterceptor;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;

import java.lang.annotation.*;

/**
 * 启用MQ的默认traceid透传功能
 *
 * @author EnableMQTraceId
 * @version EnableMQTraceId.java, v 0.1 2022-09-08 20:47
 */
@Component
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Import({TraceIdConsumeInterceptor.class, TraceIdProducerInterceptor.class})
public @interface EnableMQTraceId {

}
