package com.fshows.ark.spring.boot.starter.annotation.encrypt;

import lombok.Getter;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;


/**
 * 加解密注解
 *
 * @author zhaoxumin
 * @version LifecircleEncrypt.java, v 0.1 2024-05-27 17:29 zhaoxumin
 */
@Target({ElementType.FIELD, ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface LifecircleEncrypt {
    String value() default "";

    String secretName() default "";

    @Getter
    enum EncryptContentTypeEnum {
        DEFAULT("默认", "default"),
        SEARCH_KEYWORD("检索关键词", "searchKeyword"),
        ;

        private final String name;
        private final String value;

        EncryptContentTypeEnum(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public static EncryptContentTypeEnum getByValue(String value) {
            EncryptContentTypeEnum[] valueList = EncryptContentTypeEnum.values();
            for (EncryptContentTypeEnum v : valueList) {
                if (v.getValue().equalsIgnoreCase(value)) {
                    return v;
                }
            }
            return DEFAULT;
        }
    }
}
