/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.main;

import com.fshows.api.generate.core.config.ApiConfig;
import com.fshows.api.generate.core.config.xml.XmlConfigRead;
import com.fshows.api.generate.core.constants.XmlConstant;
import com.fshows.api.generate.core.util.helper.ApiGenerateHelper;
import com.fshows.api.generate.core.util.tool.ApiFileNameUtil;
import com.fshows.api.generate.core.util.tool.ApiFilePathUtil;
import com.fshows.api.generate.core.util.tool.ApiLogUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;
import org.w3c.dom.Document;

public class ApiGenerateMain {
    public static void main(String[] args) {
        ApiLogUtil.generateStart();
        try {
            ApiConfig config = new ApiConfig();
            Document document = ApiGenerateMain.getDocument(config, ApiGenerateMain.getCustomXmlName(args));
            ApiGenerateMain.buildApiConfig(config, document);
            ApiGenerateHelper.checkRequiredConfigByXml(config);
            ApiGenerateHelper.doRunXml(config);
        }
        catch (Exception e) {
            ApiLogUtil.printlnError(e);
        }
    }

    private static String getCustomXmlName(String[] args) {
        if (ObjectUtils.isEmpty((Object[])args)) {
            ApiLogUtil.info("\u914d\u7f6e\u6587\u4ef6\u9ed8\u8ba4 \uff1a{0}", "/ApiGeneratorConfig.xml");
            return "";
        }
        String xmlFileName = args[0];
        ApiLogUtil.info("\u81ea\u5b9a\u4e49\u542f\u52a8\u53c2\u6570\u914d\u7f6e \uff1a{0} , \u81ea\u5b9a\u4e49\u914d\u7f6e\u6587\u4ef6\u540d\uff1a{1}", Arrays.asList(args), xmlFileName);
        return args[0];
    }

    private static Document getDocument(ApiConfig apiConfig, String customXmlName) {
        String xmlParentPath = ApiFilePathUtil.getClassParentPath(ApiGenerateMain.class);
        ApiLogUtil.info("\u3010Xml\u6587\u4ef6\u81ea\u52a8\u8bfb\u53d6\u3011\u81ea\u52a8\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u8def\u5f84 \uff1a{0}", xmlParentPath);
        String autoXmlPath = xmlParentPath.concat(XmlConstant.getXmlFleName(customXmlName));
        Document document = XmlConfigRead.getDocumentByPath(autoXmlPath);
        StringBuilder generateFilePath = new StringBuilder();
        generateFilePath.append(xmlParentPath);
        if (null == document) {
            Scanner scanner = new Scanner(System.in);
            ApiLogUtil.warn("\u6587\u4ef6\u8def\u5f84: {0} \u4e0b\u672a\u83b7\u53d6\u5230\u914d\u7f6e\u6587\u4ef6", autoXmlPath);
            ApiLogUtil.info("\u8bf7\u8f93\u5165\u914d\u7f6eXml\u6587\u4ef6\u7edd\u5bf9\u8def\u5f84", new Object[0]);
            autoXmlPath = scanner.nextLine();
            ApiLogUtil.info("\u60a8\u8f93\u5165\u7684\u914d\u7f6e\u6587\u4ef6\u7edd\u5bf9\u8def\u5f84\u4e3a\uff1a{0}", autoXmlPath);
            document = XmlConfigRead.getDocumentByPath(autoXmlPath);
            generateFilePath = new StringBuilder(new File(autoXmlPath).getParent());
        }
        apiConfig.setGenerateFilePath(ApiFileNameUtil.getGenerate(String.valueOf(generateFilePath)));
        return document;
    }

    private static void buildApiConfig(ApiConfig config, Document document) {
        config.setGenerateType(XmlConfigRead.getGenerateType(document));
        config.setProjectScanPaths(XmlConfigRead.getProjectScanPaths(document));
        config.setApiPackagePath(XmlConfigRead.getApiPackagePath(document));
        config.setApiClassPathList(XmlConfigRead.getApiClassPaths(document));
        config.setApiParamType(XmlConfigRead.getApiParamType(document));
        config.setGenerateJsonFlag(XmlConfigRead.getGenerateJsonFlag(document));
        config.setApiExcludeParamNames(XmlConfigRead.getApiExcludeParamNames(document));
        config.setApiExcludeParamClassNames(XmlConfigRead.getApiExcludeParamClassNames(document));
        config.setLogLevel(XmlConfigRead.getLogLevel(document));
        config.setGateWayField(XmlConfigRead.getApiGateWayField(document));
        config.setRootRespFieldList(XmlConfigRead.getRootRespFieldList(document));
        config.setProjectRootUrl(XmlConfigRead.getProjectRootUrl(document));
        String generateFilePath = XmlConfigRead.getGenerateFilePath(document);
        if (StringUtils.isNotBlank((CharSequence)XmlConfigRead.getGenerateFilePath(document))) {
            config.setGenerateFilePath(generateFilePath);
        }
        if (StringUtils.isNotBlank((CharSequence)config.getLogLevel())) {
            ApiLogUtil.LEVEL = ApiLogUtil.getLevelByName(config.getLogLevel());
        }
    }
}

