/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.util.tool;

import org.apache.commons.lang3.StringUtils;

public class ApiTypeMatchUtil {
    public static boolean isJavaClass(String genericType) {
        return genericType.contains("java.");
    }

    public static boolean isArray(String genericType) {
        return genericType.contains("[]");
    }

    public static String[] getTArrayByTypeStr(String typeStr) {
        if (null == typeStr) {
            return new String[0];
        }
        return typeStr.replaceAll(">", "").split("<");
    }

    public static boolean isStrArray(String strType) {
        if (StringUtils.isBlank((CharSequence)strType)) {
            return false;
        }
        if (strType.contains("List")) {
            return true;
        }
        return strType.contains("Set");
    }

    public static boolean isObject(String genericType) {
        return genericType.contains("Object");
    }

    public static boolean isObjectTClass(String genericType) {
        return genericType.contains("<") && genericType.contains(">");
    }

    public static boolean isTClass(String genericType) {
        return genericType.contains("<T>");
    }

    public static boolean isTSimpleClass(String genericType) {
        return genericType.contains("T");
    }

    public static boolean isSelfClass(String genericType) {
        try {
            Class<?> paramClazz = Class.forName(genericType);
            return null != paramClazz;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isList(String genericType) {
        return genericType.contains("List");
    }

    public static boolean isSet(String genericType) {
        return genericType.contains("Set");
    }
}

