/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.util.tool;

import com.fshows.api.generate.core.util.tool.ApiLogUtil;
import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;

public class ApiTemplateUtils {
    private static final Configuration CONFIG = new Configuration();
    private static final String PATH = "/api_template";
    private static final int MAX_STRONG_SIZE = 100;
    private static final int MAX_SOFT_SIZE = 2500;

    private ApiTemplateUtils() {
    }

    public static Configuration getConfiguration() {
        return CONFIG;
    }

    public static void loggerConfig() {
        try {
            Logger.selectLoggerLibrary((int)0);
            ApiLogUtil.debug("\u52a0\u8f7d[freemarker]\u6210\u529f", new Object[0]);
        }
        catch (ClassNotFoundException e) {
            ApiLogUtil.error("\u52a0\u8f7d[freemarker]\u5931\u8d25\uff0c\u672a\u627e\u5230\u7c7b", e);
        }
    }

    public static Template getTemplate(String templateName) {
        try {
            return CONFIG.getTemplate(templateName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        CONFIG.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(ApiTemplateUtils.class, PATH));
        CONFIG.setDefaultEncoding("UTF-8");
        CONFIG.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        CONFIG.setCacheStorage((CacheStorage)new MruCacheStorage(100, 2500));
    }
}

