/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.util.tool;

import com.fshows.api.generate.core.exception.ApiGenerateException;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ApiLogUtil {
    private static final int DEBUG = 1;
    private static final int INFO = 2;
    private static final int WARN = 2;
    private static final int ERROR = 2;
    private static final String INFO_STR = "info";
    private static final String DEBUG_STR = "debug";
    private static final String WARN_STR = "warn";
    private static final String ERROR_STR = "error";
    public static int LEVEL = 2;

    public static void debug(String mess, Object ... args) {
        if (LEVEL <= 1) {
            System.out.println(MessageFormat.format(">>> " + mess, args));
        }
    }

    public static void info(String mess, Object ... args) {
        if (LEVEL <= 2) {
            System.out.println(MessageFormat.format(">>> " + mess, args));
        }
    }

    public static void warn(String mess, Object ... args) {
        if (LEVEL <= 2) {
            System.err.println(MessageFormat.format(">>>\u3010\u8b66\u544a\u3011>>> " + mess, args));
        }
    }

    public static void error(String mess, Object ... args) {
        if (LEVEL <= 2) {
            ApiLogUtil.newLine();
            System.err.println(MessageFormat.format(">>>\u3010\u5f02\u5e38\u3011>>> " + mess, args));
        }
    }

    public static void newLine() {
        System.out.println();
    }

    public static void newDebugLine() {
        if (LEVEL <= 1) {
            System.out.println();
        }
    }

    public static void generateStart() {
        ApiLogUtil.newLine();
        ApiLogUtil.info("********************** ^_^ \u63a5\u53e3\u6587\u6863\u751f\u6210\u5f00\u59cb ^_^ **********************", new Object[0]);
    }

    public static void generateError() {
        if (LEVEL <= 2) {
            ApiLogUtil.newLine();
            System.err.println(">>> ********************** T_T \u63a5\u53e3\u6587\u6863\u751f\u6210\u5931\u8d25 T_T **********************");
        }
    }

    public static void generateEnd() {
        ApiLogUtil.newLine();
        ApiLogUtil.info("********************** ^_^ \u63a5\u53e3\u6587\u6863\u751f\u6210\u7ed3\u675f ^_^ **********************", new Object[0]);
    }

    public static void printlnError(Exception e) {
        ApiLogUtil.generateError();
        if (e instanceof ApiGenerateException) {
            ApiLogUtil.error("\u5931\u8d25\u539f\u56e0\uff1a {0}", e.getMessage());
        } else {
            ApiLogUtil.error("\u5931\u8d25\u539f\u56e0\uff1a \u672a\u77e5\u5f02\u5e38 stack={0}", ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static Integer getLevelByName(String levelName) {
        if (StringUtils.isBlank((CharSequence)levelName)) {
            return LEVEL;
        }
        if (INFO_STR.equalsIgnoreCase(levelName)) {
            return 2;
        }
        if (DEBUG_STR.equalsIgnoreCase(levelName)) {
            return 1;
        }
        if (WARN_STR.equalsIgnoreCase(levelName)) {
            return 2;
        }
        if (ERROR_STR.equalsIgnoreCase(levelName)) {
            return 2;
        }
        return LEVEL;
    }
}

