/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.util.tool;

import com.fshows.api.generate.core.constants.JsonValueConstant;
import com.fshows.api.generate.core.util.tool.ApiRandomUtil;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ApiJsonRandomValueUtil {
    public static Object randomValue(String[] fileTypes, String fileName) {
        if (1 == fileTypes.length) {
            return ApiJsonRandomValueUtil.randomValue(fileTypes[0], fileName);
        }
        AbstractCollection result = null;
        for (int i = fileTypes.length - 1; i >= 0; --i) {
            String fileType = fileTypes[i];
            if (fileType.contains("List")) {
                if (null == result) continue;
                ArrayList objectList = new ArrayList();
                objectList.add(result);
                result = objectList;
                continue;
            }
            if (fileType.contains("Set")) {
                if (null == result) continue;
                HashSet objectSet = new HashSet();
                objectSet.add(result);
                result = objectSet;
                continue;
            }
            result = ApiJsonRandomValueUtil.randomValue(fileType, fileName);
        }
        return result;
    }

    public static Object randomValue(String fileType, String filedName) {
        if (StringUtils.isBlank((CharSequence)fileType) || StringUtils.isBlank((CharSequence)filedName)) {
            return "";
        }
        String string = fileType = (fileType = fileType.trim().replaceAll("\\[]", "")).contains(".") ? fileType.substring(fileType.lastIndexOf(".") + 1, fileType.length()) : fileType;
        if ("String".equals(fileType)) {
            return ApiJsonRandomValueUtil.getRandomStringValue(filedName);
        }
        if ("Integer".equals(fileType) || "int".equals(fileType) || "BigInteger".equals(fileType)) {
            return ApiJsonRandomValueUtil.getRandomIntValue(filedName);
        }
        if ("Date".equals(fileType) || "LocalDate".equals(fileType) || "LocalDateTime".equals(fileType)) {
            return new Date();
        }
        if ("boolean".equalsIgnoreCase(fileType)) {
            return Boolean.TRUE;
        }
        if ("BigDecimal".equals(fileType)) {
            return ApiRandomUtil.randomDouble();
        }
        if ("List".equals(fileType)) {
            return new ArrayList(0);
        }
        if ("long".equalsIgnoreCase(fileType)) {
            return ApiJsonRandomValueUtil.getRandomLongValue(filedName);
        }
        if ("double".equalsIgnoreCase(fileType)) {
            return ApiRandomUtil.randomDouble();
        }
        if ("Object".equals(fileType)) {
            return new Object();
        }
        if ("T".equals(fileType)) {
            return new Object();
        }
        if ("float".equalsIgnoreCase(fileType)) {
            return ApiRandomUtil.randomDouble();
        }
        if ("byte".equalsIgnoreCase(fileType) || "short".equalsIgnoreCase(fileType)) {
            return ApiJsonRandomValueUtil.getRandomIntValue(filedName);
        }
        if ("char".equals(fileType) || "Character".equals(fileType)) {
            return ApiJsonRandomValueUtil.getRandomStringValue(filedName);
        }
        if ("Timestamp".equals(fileType)) {
            return System.currentTimeMillis();
        }
        return ApiRandomUtil.randomString(10);
    }

    private static Long getRandomLongValue(String filedName) {
        for (Map.Entry<String, Long> entry : JsonValueConstant.LONG_VALUE_MAP.entrySet()) {
            if (!filedName.toLowerCase().contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return System.currentTimeMillis();
    }

    private static String getRandomStringValue(String filedName) {
        for (Map.Entry<String, String> entry : JsonValueConstant.getStringMap().entrySet()) {
            if (!filedName.toLowerCase().contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return ApiRandomUtil.randomString(12);
    }

    private static Integer getRandomIntValue(String filedName) {
        for (Map.Entry<String, Integer> entry : JsonValueConstant.INT_VALUE_MAP.entrySet()) {
            if (!filedName.toLowerCase().contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return ApiRandomUtil.randomInt(1000);
    }
}

