/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.util.tool;

import com.fshows.api.generate.core.util.tool.ApiLogUtil;

public class ApiFilePathUtil {
    private static final String MAIN_JAVA_PATH = "/main/java/";
    private static final String JAVA_SUFFIX = ".java";
    private static final String FILE_PREFIX = "file:";
    private static final String TARGET_STR = "target";
    private static final String JAR_SUFFIX = ".jar";

    public static String getRootPath() {
        return System.getProperty("user.dir");
    }

    public static String getClassParentPath(Class clazz) {
        if (null == clazz) {
            return "/";
        }
        String targetPath = clazz.getResource("").getPath();
        if (targetPath.contains(FILE_PREFIX)) {
            targetPath = targetPath.replaceAll(FILE_PREFIX, "");
        }
        if (targetPath.contains(TARGET_STR)) {
            return targetPath.substring(0, targetPath.indexOf(TARGET_STR));
        }
        if (targetPath.contains(JAR_SUFFIX)) {
            String substring = targetPath.substring(0, targetPath.indexOf(JAR_SUFFIX));
            ApiLogUtil.debug("\u3010Jar\u6587\u4ef6\u3011\u7edd\u5bf9\u8def\u5f84 \uff1a{0}", substring);
            return targetPath.substring(0, substring.lastIndexOf("/"));
        }
        return ApiFilePathUtil.getRootPath();
    }

    public static String getClassProjectPath(Class clazz) {
        if (null == clazz) {
            return "/";
        }
        String targetPath = clazz.getResource("/").getPath();
        return targetPath.substring(0, targetPath.indexOf(TARGET_STR));
    }

    public static String getClassProjectJavaPath(Class clazz) {
        return ApiFilePathUtil.getClassProjectPath(clazz).concat("src/main/java/");
    }

    public static String getClassProjectJavaSrcPath(Class clazz) {
        return ApiFilePathUtil.getClassProjectPath(clazz).concat("src/");
    }

    public static String getClassProjectJavaPath(Class clazz, String className) {
        return ApiFilePathUtil.getJavaPathBySrcAndPackage(ApiFilePathUtil.getClassProjectJavaSrcPath(clazz), className);
    }

    public static String getClassProjectPackagePath(Class clazz, String packageName) {
        return ApiFilePathUtil.getClassProjectJavaPath(clazz).concat(packageName.replaceAll("\\.", "/"));
    }

    public static String getJavaPathBySrcAndPackage(String srcPath, String packagePath) {
        StringBuilder path = new StringBuilder(srcPath);
        path.append(MAIN_JAVA_PATH).append(packagePath.replaceAll("\\.", "/")).append(JAVA_SUFFIX);
        String rPath = String.valueOf(path);
        if (rPath.contains("$")) {
            String[] split = rPath.split("\\$");
            return split[0].concat(JAVA_SUFFIX);
        }
        return rPath;
    }
}

