/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.util.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.fshows.api.generate.core.config.ApiConfig;
import com.fshows.api.generate.core.config.custom.ApiRootResField;
import com.fshows.api.generate.core.constants.ApiSetConstant;
import com.fshows.api.generate.core.enums.ApiParamTypeEnum;
import com.fshows.api.generate.core.model.ApiReqParamModel;
import com.fshows.api.generate.core.model.ApiResParamModel;
import com.fshows.api.generate.core.model.ParamModel;
import com.fshows.api.generate.core.model.convert.ApiAtomicCountModel;
import com.fshows.api.generate.core.model.convert.ApiFieldParamModel;
import com.fshows.api.generate.core.util.helper.ApiClassHelper;
import com.fshows.api.generate.core.util.helper.ApiMatchAnnoHelper;
import com.fshows.api.generate.core.util.tool.ApiJsonFormatUtil;
import com.fshows.api.generate.core.util.tool.ApiJsonRandomValueUtil;
import com.fshows.api.generate.core.util.tool.ApiLogUtil;
import com.fshows.api.generate.core.util.tool.ApiStringUtil;
import com.fshows.api.generate.core.util.tool.ApiTypeMatchUtil;
import com.google.common.base.CaseFormat;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ApiParamHelper {
    private static final int ZERO = 0;
    private static final int ONE = 1;

    public static ApiReqParamModel getReqParam(JavaProjectBuilder rootBuilder, Set<String> lessPackageSet, JavaMethod method, Set<String> paramExcludeSet, ApiConfig config) {
        List parameterList = method.getParameters();
        ApiLogUtil.debug("\u3010\u5165\u53c2\u3011>> \u5f53\u524d\u65b9\u6cd5\uff1a{0} , \u53c2\u6570\u6570\u91cf\u91cf\uff1a{1} ", method.getName(), parameterList.size());
        ArrayList<ParamModel> resultParamList = new ArrayList<ParamModel>(0);
        if (CollectionUtils.isEmpty((Collection)parameterList)) {
            return new ApiReqParamModel();
        }
        ParamModel paramModel = null;
        int paramTotalLevel = 1;
        int paramTotalSize = 1;
        ArrayList<String> jsonExampleList = new ArrayList<String>(parameterList.size());
        for (JavaParameter parameter : parameterList) {
            String parameterFullName = parameter.getFullyQualifiedName();
            ApiLogUtil.debug("\u3010\u5165\u53c2\u3011>> \u5f53\u524d\u65b9\u6cd5\uff1a{0} \u53c2\u6570\uff1a{1} ,name={2} ", method.getName(), parameterFullName, parameter.getName());
            if (paramExcludeSet.contains(parameterFullName) || config.getApiExcludeParamNames().contains(parameter.getName())) {
                ApiLogUtil.debug("\u3010\u5165\u53c2\u3011>>\u3010\u53c2\u6570\u6392\u9664\u3011\u5f53\u524d\u65b9\u6cd5\uff1a{0},\u53c2\u6570\u540d\uff1a{1} ,\u5df2\u7ecf\u81ea\u52a8\u8fc7\u6ee4", method.getName(), parameter.getName());
                continue;
            }
            if (ApiTypeMatchUtil.isJavaClass(parameterFullName) || ApiSetConstant.BASE_TYPE_SET.contains(parameterFullName)) {
                paramModel = ApiParamHelper.convertReqParamModel(parameter);
                resultParamList.add(paramModel);
                continue;
            }
            ApiLogUtil.debug("\u3010\u5165\u53c2\u3011>> \u5f53\u524d\u65b9\u6cd5\uff1a{0} \u53c2\u6570\uff1a{1} , \u8fdb\u5165\u81ea\u5b9a\u4e49\u53c2\u6570\u5904\u7406 ", method.getName(), parameterFullName, parameter.getName());
            ApiFieldParamModel fieldParamModel = ApiParamHelper.getFieldModel(rootBuilder, lessPackageSet, parameterFullName, Boolean.FALSE);
            resultParamList.addAll(fieldParamModel.getParamList());
            if (ApiParamTypeEnum.SNAKE_CASE.equals((Object)config.getApiParamType())) {
                jsonExampleList.add(ApiParamHelper.getSnakeCaseJson(fieldParamModel.getJsonObject()));
            } else {
                jsonExampleList.add(ApiJsonFormatUtil.toFormatJson(fieldParamModel.getJsonObject()));
            }
            if (fieldParamModel.getParamTotalLevel() > paramTotalLevel) {
                paramTotalLevel = fieldParamModel.getParamTotalLevel();
            }
            paramTotalSize += fieldParamModel.getParamTotalSize().intValue();
        }
        ApiLogUtil.debug("\u3010\u5165\u53c2\u3011 >> \u6700\u5927\u5c42\u7ea7\uff1a{0} \u53c2\u6570\u603b\u6570\uff1a{1}", paramTotalLevel, paramTotalLevel);
        return new ApiReqParamModel(resultParamList, paramTotalSize, paramTotalLevel, jsonExampleList);
    }

    public static ApiResParamModel getResParam(JavaProjectBuilder rootBuilder, Set<String> lessPackageSet, JavaMethod method, ApiConfig config) {
        String genericFullyReturnName = method.getReturns().getGenericFullyQualifiedName();
        ApiLogUtil.debug("\u3010\u51fa\u53c2\u3011>> \u5f53\u524d\u65b9\u6cd5\uff1a{0} , \u53c2\u6570\u6570\u91cf\uff1a{1}", method.getName(), genericFullyReturnName);
        if ("void".equals(genericFullyReturnName)) {
            return null;
        }
        ApiResParamModel currentApi = null;
        boolean isArrayFlag = false;
        if (ApiSetConstant.BASE_TYPE_SET.contains(genericFullyReturnName)) {
            currentApi = ApiParamHelper.buildApiResParamModel(method);
        } else if (ApiTypeMatchUtil.isJavaClass(genericFullyReturnName) && !ApiTypeMatchUtil.isObjectTClass(genericFullyReturnName)) {
            currentApi = ApiParamHelper.buildApiResParamModel(method);
        } else {
            ApiResParamModel childModel = null;
            String[] resClassArray = ApiTypeMatchUtil.getTArrayByTypeStr(genericFullyReturnName);
            for (int i = resClassArray.length - 1; i >= 0; --i) {
                ApiLogUtil.debug("\u3010\u51fa\u53c2\u3011>> \u65b9\u6cd5\uff1a{0} , \u8fd4\u56de\u53c2\u6570\u5f53\u524d\uff1a{1} ", method.getName(), resClassArray[i]);
                if (ApiTypeMatchUtil.isJavaClass(genericFullyReturnName) && ApiTypeMatchUtil.isStrArray(resClassArray[i])) {
                    isArrayFlag = true;
                    continue;
                }
                ApiFieldParamModel currentParamModel = ApiParamHelper.getFieldModel(rootBuilder, lessPackageSet, resClassArray[i], Boolean.TRUE);
                currentApi = ApiParamHelper.convertResApiParam(currentParamModel, config);
                ApiParamHelper.doResAddChildModel(childModel, currentApi);
                childModel = currentApi;
            }
            ApiLogUtil.debug("\u3010\u51fa\u53c2\u3011>> \u6cdb\u578b\u5c42\u7ea7\uff1a{0}", resClassArray.length);
        }
        if (null == currentApi) {
            return null;
        }
        ApiLogUtil.debug("\u3010\u51fa\u53c2\u3011>> \u53c2\u6570\u6700\u5927\u5c42\u7ea7\uff1a{0} , \u53c2\u6570\u603b\u6570\uff1a{1},", currentApi.getParamTotalLevel(), currentApi.getParamTotalSize());
        return ApiParamHelper.buildResParamModel(currentApi, config, isArrayFlag);
    }

    private static ApiFieldParamModel getFieldModel(JavaProjectBuilder rootBuilder, Set<String> lessPackageSet, String clazzFullName, Boolean paramRequiredCheckFlag) {
        AtomicInteger paramTotalSize = new AtomicInteger(0);
        AtomicInteger paramTotalLevel = new AtomicInteger(0);
        AtomicInteger currentLevel = new AtomicInteger(1);
        AtomicInteger hasChildParamTotalSize = new AtomicInteger(0);
        ApiAtomicCountModel countModel = new ApiAtomicCountModel(paramTotalSize, paramTotalLevel, currentLevel);
        countModel.setHasChildParamTotalSize(hasChildParamTotalSize);
        ApiFieldParamModel fieldBase = ApiParamHelper.getFieldBase(rootBuilder, countModel, null, null, clazzFullName, paramRequiredCheckFlag);
        if (!clazzFullName.contains(".") && CollectionUtils.isEmpty(fieldBase.getParamList()) && CollectionUtils.isNotEmpty(lessPackageSet)) {
            ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6-\u5c1d\u8bd5\u4e8c\u6b21\u83b7\u53d6\u3011>> \u7c7b\u540d:{0} \u5c06\u5c1d\u8bd5\u518d\u6b21\u83b7\u53d6\uff01", clazzFullName);
            for (String lessPackage : lessPackageSet) {
                String currentClassName = lessPackage.replace("*", "").concat(clazzFullName);
                ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6-\u5c1d\u8bd5\u4e8c\u6b21\u83b7\u53d6\u3011>> \u5f53\u524d\u62fc\u63a5\u540e\u7c7b\u540d:{0}", currentClassName);
                ApiFieldParamModel currentBase = ApiParamHelper.getFieldBase(rootBuilder, countModel, null, null, currentClassName, paramRequiredCheckFlag);
                if (!CollectionUtils.isNotEmpty(currentBase.getParamList())) continue;
                ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6-\u5c1d\u8bd5\u4e8c\u6b21\u83b7\u53d6\u3011>> \u5f53\u524d\u7c7b\u4e0d\u4e3a\u7a7a\u5c06\u8fd4\u56de:{0}", currentClassName);
                return currentBase;
            }
        }
        return fieldBase;
    }

    private static ApiFieldParamModel getFieldBase(JavaProjectBuilder rootBuilder, ApiAtomicCountModel countModel, ParamModel parentModel, JSONObject parentJsonObject, String clazzFullName, Boolean paramRequiredCheckFlag) {
        JavaClass currentClass = rootBuilder.getClassByName(clazzFullName);
        if (null == currentClass) {
            ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6\u3011>> \u7c7b\u540d:{0} \u5f53\u524d\u7c7b\u4e3a\u7a7a\uff01", clazzFullName);
            return new ApiFieldParamModel(new ArrayList<ParamModel>(0));
        }
        List<JavaField> fieldList = ApiClassHelper.getAllFields(currentClass);
        if (CollectionUtils.isEmpty(fieldList)) {
            ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6\u3011>> \u7c7b\u540d:{0} \u5f53\u524d\u7c7b\u65e0\u5c5e\u6027\uff01currentClass:{1}", clazzFullName, currentClass);
            return new ApiFieldParamModel(new ArrayList<ParamModel>(0));
        }
        int level = countModel.getCurrentLevel().intValue();
        if (countModel.getCurrentLevel().intValue() > countModel.getParamTotalLevel().intValue()) {
            countModel.getParamTotalLevel().set(countModel.getCurrentLevel().intValue());
        }
        ParamModel currentParam = null;
        ArrayList<ParamModel> paramList = new ArrayList<ParamModel>();
        JSONObject currentJsonObject = new JSONObject(true);
        for (JavaField field : fieldList) {
            String fullFileTypeName = field.getType().getGenericFullyQualifiedName();
            if (ApiSetConstant.FIELD_EXCLUDE_SET.contains(field.getName())) {
                ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6\u3011>>\u3010\u53c2\u6570\u8fc7\u6ee4\u3011\u53c2\u6570\u540d:{0} \u53c2\u6570\u63cf\u8ff0:{1},\u53c2\u6570\u7c7b\u578b:{2}", field.getName(), field.getComment(), fullFileTypeName);
                continue;
            }
            currentParam = ApiParamHelper.buildFileModel(currentJsonObject, field, paramRequiredCheckFlag);
            ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6\u3011>> \u5f53\u524d\u53c2\u6570\u540d:{0} \u53c2\u6570\u63cf\u8ff0:{1},\u53c2\u6570\u7c7b\u578b:{2},\u5f53\u524d\u5c42\u7ea7\uff1a{3}-{4}-{5}", field.getName(), field.getComment(), fullFileTypeName, countModel.getCurrentLevel(), countModel.getParamTotalLevel(), field.getType().getFullyQualifiedName());
            if (parentModel != null) {
                parentModel.setChildParamSize(parentModel.getChildParamSize() + 1);
            }
            boolean hasChildFlag = ApiParamHelper.doProcessParamByType(rootBuilder, countModel, currentParam, currentJsonObject, clazzFullName, fullFileTypeName, paramRequiredCheckFlag);
            if (parentModel != null && hasChildFlag) {
                parentModel.setHasChildParamSize(parentModel.getHasChildParamSize() + 1);
                ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6\u3011>>\u3010\u5b58\u5728\u7236\u7ea7\u3011\u540d\u79f0\uff1a{0},\u5f53\u524dSize:{1}", parentModel.getName(), parentModel.getHasChildParamSize());
            }
            countModel.getCurrentLevel().set(level);
            if (null != parentModel) {
                if (CollectionUtils.isEmpty(parentModel.getChildren())) {
                    ArrayList<ParamModel> paramModelList = new ArrayList<ParamModel>();
                    paramModelList.add(currentParam);
                    parentModel.setChildren(paramModelList);
                } else {
                    parentModel.getChildren().add(currentParam);
                }
                parentModel.setChildParamSize(parentModel.getChildParamSize() + currentParam.getChildParamSize());
                parentModel.setHasChildParamSize(parentModel.getHasChildParamSize() + currentParam.getHasChildParamSize());
                ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6\u3011>>\u3010\u9012\u5f52\u540e-\u5b58\u5728\u7236\u7ea7\u3011\u7236\u540d\u79f0\uff1a{0},\u7236\u5f53\u524dSize:{1}\uff0c\u5b50\u540d\u79f0\uff1a{2},\u5b50\u5f53\u524dSize:{3}", parentModel.getName(), parentModel.getHasChildParamSize(), currentParam.getName(), currentParam.getHasChildParamSize());
                ApiParamHelper.convertJson(parentModel, parentJsonObject, currentJsonObject);
            }
            countModel.getParamTotalSize().incrementAndGet();
            paramList.add(currentParam);
        }
        return ApiParamHelper.convertApiFieldParamModel(paramList, currentJsonObject, countModel);
    }

    private static boolean doProcessParamByType(JavaProjectBuilder rootBuilder, ApiAtomicCountModel countModel, ParamModel currentParam, JSONObject currentJsonObject, String clazzFullName, String fullFileTypeName, Boolean paramRequiredCheckFlag) {
        if (!ApiTypeMatchUtil.isJavaClass(fullFileTypeName) && ApiTypeMatchUtil.isArray(fullFileTypeName)) {
            String currentClassName = ApiStringUtil.replaceInBracket(fullFileTypeName);
            countModel.getCurrentLevel().incrementAndGet();
            ApiParamHelper.getFieldBase(rootBuilder, countModel, currentParam, currentJsonObject, currentClassName, paramRequiredCheckFlag);
            return true;
        }
        if (ApiTypeMatchUtil.isJavaClass(fullFileTypeName) && ApiTypeMatchUtil.isObjectTClass(fullFileTypeName)) {
            String[] tArrayByTypeStr = ApiTypeMatchUtil.getTArrayByTypeStr(fullFileTypeName);
            ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6\u3011>> \u5c5e\u6027\u5339\u914d\u5b57\u7b26\u4e32\u4e2d\u7684\u6cdb\u578b\uff1a{0} ", Arrays.asList(tArrayByTypeStr));
            for (String type : tArrayByTypeStr) {
                if (!clazzFullName.equals(type) && !ApiTypeMatchUtil.isJavaClass(type)) {
                    countModel.getCurrentLevel().incrementAndGet();
                    ApiParamHelper.getFieldBase(rootBuilder, countModel, currentParam, currentJsonObject, type, paramRequiredCheckFlag);
                    return true;
                }
                currentParam.setType(currentParam.getType().concat("<T>"));
            }
        } else if (!ApiTypeMatchUtil.isJavaClass(fullFileTypeName) && !ApiSetConstant.BASE_TYPE_SET.contains(fullFileTypeName)) {
            countModel.getCurrentLevel().incrementAndGet();
            ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6\u3011>> \u3010\u9012\u5f52\u83b7\u53d6\u5c5e\u6027\u3011\u81ea\u5b9a\u4e49\u7c7b\uff1a{0} \u5f53\u524d\u5c42\u7ea7\uff1a{1}", fullFileTypeName, countModel.getCurrentLevel().intValue());
            ApiParamHelper.getFieldBase(rootBuilder, countModel, currentParam, currentJsonObject, fullFileTypeName, paramRequiredCheckFlag);
            return true;
        }
        return false;
    }

    private static ParamModel buildFileModel(JSONObject currentJsonObject, JavaField field, Boolean paramRequiredFlag) {
        Map<String, JavaAnnotation> fileAnnotationMap = ApiMatchAnnoHelper.getFileAnnotationMap(field);
        ParamModel currentParam = new ParamModel();
        currentParam.setType(field.getType().getName());
        currentParam.setName(field.getName());
        if (StringUtils.isNotBlank((CharSequence)field.getComment())) {
            String replace = field.getComment().replaceAll("\\n", "").replaceAll("\\r", "");
            currentParam.setDescription(replace);
        }
        currentParam.setRequiredFlag(ApiMatchAnnoHelper.getRequiredFlagFlag(fileAnnotationMap));
        if (paramRequiredFlag.booleanValue()) {
            currentParam.setRequiredFlag(1);
        } else {
            currentParam.setRequiredFlag(ApiMatchAnnoHelper.getRequiredFlagFlag(fileAnnotationMap));
        }
        currentParam.setLength(ApiMatchAnnoHelper.getLength(fileAnnotationMap).replaceAll("\"", ""));
        ApiLogUtil.debug("\u3010\u53c2\u6570\u83b7\u53d6\u3011>> \u5f53\u524d\u53c2\u6570\u540d:{0},\u662f\u5426\u5fc5\u586b:{1},\u957f\u5ea6:{2},\u6ce8\u89e3\u96c6size:{3},\u6ce8\u89e3\u96c6:{4}", field.getName(), currentParam.getRequiredFlag(), currentParam.getLength(), fileAnnotationMap.size(), fileAnnotationMap);
        currentJsonObject.put(field.getName(), ApiParamHelper.getJsonValueByType(field));
        return currentParam;
    }

    private static ApiFieldParamModel convertApiFieldParamModel(List<ParamModel> paramList, JSONObject currentJsonObject, ApiAtomicCountModel countModel) {
        ApiFieldParamModel paramModel = new ApiFieldParamModel();
        paramModel.setParamList(paramList);
        paramModel.setJsonObject(currentJsonObject);
        paramModel.setParamTotalLevel(countModel.getParamTotalLevel().intValue());
        paramModel.setParamTotalSize(countModel.getParamTotalSize().intValue());
        return paramModel;
    }

    private static void doResAddChildModel(ApiResParamModel childModel, ApiResParamModel currentApi) {
        if (null == childModel || CollectionUtils.isEmpty(currentApi.getParamList())) {
            return;
        }
        for (ParamModel paramModel : currentApi.getParamList()) {
            ApiLogUtil.debug("\u3010\u51fa\u53c2\u3011>> \u3010\u6cdb\u578b\u5c42\u7ea7\u5904\u7406\u3011\u5f53\u524d\u53c2\u6570\uff1a{0}", paramModel.getType());
            if (!ApiTypeMatchUtil.isObject(paramModel.getType()) && !ApiTypeMatchUtil.isTSimpleClass(paramModel.getType()) && !ApiTypeMatchUtil.isTClass(paramModel.getType())) continue;
            paramModel.setChildParamSize(childModel.getParamTotalSize());
            paramModel.setChildren(childModel.getParamList());
            paramModel.setType(paramModel.getType().replace("<T>", ""));
            JSONObject jsonObject = JSONObject.parseObject((String)currentApi.getJsonExample(), (Feature[])new Feature[]{Feature.OrderedField});
            if (ApiTypeMatchUtil.isStrArray(paramModel.getType())) {
                JSONArray jsonArray = new JSONArray();
                jsonArray.add((Object)JSONObject.parseObject((String)childModel.getJsonExample(), (Feature[])new Feature[]{Feature.OrderedField}));
                jsonObject.put(paramModel.getName(), (Object)jsonArray);
            } else {
                jsonObject.put(paramModel.getName(), (Object)JSONObject.parseObject((String)childModel.getJsonExample(), (Feature[])new Feature[]{Feature.OrderedField}));
            }
            currentApi.setJsonExample(ApiJsonFormatUtil.toFormatJson(jsonObject));
            currentApi.setParamTotalSize(currentApi.getParamTotalSize() + childModel.getParamTotalSize());
            currentApi.setParamTotalLevel(currentApi.getParamTotalLevel() + childModel.getParamTotalLevel());
            break;
        }
        ApiParamHelper.doBuildHasChildParamSize(currentApi);
    }

    private static ApiResParamModel buildResParamModel(ApiResParamModel currentApi, ApiConfig config, boolean isArrayFlag) {
        if (null == currentApi || CollectionUtils.isEmpty(currentApi.getParamList())) {
            return currentApi;
        }
        boolean rootRespFieldEmpty = CollectionUtils.isEmpty(config.getRootRespFieldList());
        if (isArrayFlag && rootRespFieldEmpty) {
            ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>(1);
            jsonObjectList.add(JSONObject.parseObject((String)currentApi.getJsonExample(), (Feature[])new Feature[]{Feature.OrderedField}));
            currentApi.setJsonExample(ApiJsonFormatUtil.toFormatJson(jsonObjectList));
            return currentApi;
        }
        if (rootRespFieldEmpty) {
            return currentApi;
        }
        ApiLogUtil.debug("\u3010\u81ea\u5b9a\u4e49\u8fd4\u56de\u57fa\u7c7b\u3011 >> \u5c5e\u6027\u96c6\u5927\u5c0f\uff1a{0},\u5f53\u524d\u53c2\u6570\u96c6\u5927\u5c0f\uff1a{1}", config.getRootRespFieldList().size(), currentApi.getParamList());
        ApiResParamModel resParamModel = new ApiResParamModel();
        JSONObject jsonObject = new JSONObject(true);
        ArrayList<ParamModel> paramList = new ArrayList<ParamModel>(config.getRootRespFieldList().size());
        for (ApiRootResField rootRespField : config.getRootRespFieldList()) {
            Class typeClass = rootRespField.getTypeClass();
            ParamModel paramModel = new ParamModel();
            paramModel.setName(rootRespField.getName());
            paramModel.setType(typeClass.getSimpleName());
            paramModel.setDescription(rootRespField.getDesc());
            jsonObject.put(rootRespField.getName(), ApiJsonRandomValueUtil.randomValue(typeClass.getTypeName(), rootRespField.getName()));
            if (rootRespField.getParent().booleanValue()) {
                paramModel.setChildren(currentApi.getParamList());
                paramModel.setChildParamSize(currentApi.getParamTotalSize());
                if (typeClass.getSimpleName().equalsIgnoreCase("List") || isArrayFlag) {
                    ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>(1);
                    jsonObjectList.add(JSONObject.parseObject((String)currentApi.getJsonExample(), (Feature[])new Feature[]{Feature.OrderedField}));
                    jsonObject.put(rootRespField.getName(), jsonObjectList);
                } else {
                    jsonObject.put(rootRespField.getName(), (Object)JSONObject.parseObject((String)currentApi.getJsonExample(), (Feature[])new Feature[]{Feature.OrderedField}));
                }
            }
            paramList.add(paramModel);
        }
        if (ApiParamTypeEnum.SNAKE_CASE.equals((Object)config.getApiParamType())) {
            resParamModel.setJsonExample(ApiParamHelper.getSnakeCaseJson(jsonObject));
        } else {
            resParamModel.setJsonExample(ApiJsonFormatUtil.toFormatJson(jsonObject));
        }
        resParamModel.setParamList(paramList);
        resParamModel.setParamTotalLevel(currentApi.getParamTotalLevel() + 1);
        ApiLogUtil.debug("\u3010\u81ea\u5b9a\u4e49\u8fd4\u56de\u57fa\u7c7b\u3011 >> \u5f53\u524d\u96c6\u5408\u5927\u5c0f\uff1a{0}", paramList.size());
        resParamModel.setParamTotalSize(currentApi.getParamTotalSize() + paramList.size());
        ApiParamHelper.doBuildHasChildParamSize(resParamModel);
        return resParamModel;
    }

    private static void doBuildHasChildParamSize(ApiResParamModel currentApi) {
        if (null == currentApi || CollectionUtils.isEmpty(currentApi.getParamList())) {
            return;
        }
        ApiLogUtil.newDebugLine();
        for (ParamModel paramModel : currentApi.getParamList()) {
            if (!CollectionUtils.isNotEmpty(paramModel.getChildren())) continue;
            boolean hasGrandSonFlag = false;
            boolean hasChildParamSizeFlag = false;
            for (ParamModel childM : paramModel.getChildren()) {
                if (!CollectionUtils.isNotEmpty(childM.getChildren())) continue;
                hasGrandSonFlag = true;
                if (childM.getHasChildParamSize() == 0) {
                    paramModel.setHasChildParamSize(paramModel.getHasChildParamSize() + 1);
                }
                if (childM.getHasChildParamSize() > 0) {
                    hasChildParamSizeFlag = true;
                    paramModel.setHasChildParamSize(paramModel.getHasChildParamSize() + childM.getHasChildParamSize());
                }
                ApiLogUtil.debug("\u3010\u8fd4\u53c2\u5904\u7406\u3011>> \u3010\u62e5\u6709\u81ea\u53c2\u6570\u7684\u53c2\u6570\u6570\u91cf\u3011\u7236\u7ea7\u540d\uff1a{0} \u7236\u5f53\u524d\u5c42\u7ea7\uff1a{1},\u5b50\u96c6\u540d\uff1a{2}", paramModel.getName(), paramModel.getHasChildParamSize(), childM.getName());
            }
            if (!hasChildParamSizeFlag && hasGrandSonFlag) {
                paramModel.setHasChildParamSize(paramModel.getHasChildParamSize() - 1);
            }
            if (hasGrandSonFlag) {
                paramModel.setHasChildParamSize(paramModel.getHasChildParamSize() + 1);
            }
            ApiLogUtil.debug("\u3010\u8fd4\u53c2\u5904\u7406\u3011>> \u3010\u5339\u914d\u540e\u5c42\u7ea7\u3011\u81ea\u5b9a\u4e49\u7c7b\uff1a{0} \u6700\u5927\u5c42\u7ea7\uff1a{1},hasChildChild\uff1a{2}", paramModel.getName(), paramModel.getHasChildParamSize(), hasGrandSonFlag);
        }
    }

    private static Object getJsonValueByType(JavaField field) {
        String paramType = field.getType().getGenericFullyQualifiedName();
        String paramName = field.getName();
        if (ApiTypeMatchUtil.isObjectTClass(paramType)) {
            String[] paramArray = ApiTypeMatchUtil.getTArrayByTypeStr(paramType);
            return ApiJsonRandomValueUtil.randomValue(paramArray, paramName);
        }
        Object jsonValue = ApiJsonRandomValueUtil.randomValue(new String[]{paramType}, paramName);
        if (ApiTypeMatchUtil.isArray(paramType)) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(jsonValue);
            return list;
        }
        return jsonValue;
    }

    private static void convertJson(ParamModel parentModel, JSONObject parentJsonObject, JSONObject currentJsonObject) {
        if (ApiTypeMatchUtil.isStrArray(parentModel.getType())) {
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)currentJsonObject);
            parentJsonObject.put(parentModel.getName(), (Object)jsonArray);
        } else {
            parentJsonObject.put(parentModel.getName(), (Object)currentJsonObject);
        }
    }

    private static ParamModel convertReqParamModel(JavaParameter parameter) {
        ParamModel paramModel = new ParamModel();
        paramModel.setName(parameter.getName());
        paramModel.setType(parameter.getType().getGenericValue());
        paramModel.setRequiredFlag(ApiMatchAnnoHelper.getJavaTypeRequired(parameter));
        return paramModel;
    }

    private static ApiResParamModel buildApiResParamModel(JavaMethod method) {
        ArrayList<ParamModel> paramList = new ArrayList<ParamModel>();
        ParamModel paramModel = new ParamModel();
        paramModel.setName("-");
        paramModel.setType(method.getReturns().getName());
        paramModel.setRequiredFlag(1);
        paramList.add(paramModel);
        ApiResParamModel currentApi = new ApiResParamModel();
        currentApi.setParamTotalSize(1);
        currentApi.setParamList(paramList);
        return currentApi;
    }

    private static ApiResParamModel convertResApiParam(ApiFieldParamModel currentParamModel, ApiConfig config) {
        ApiResParamModel currentApi = new ApiResParamModel();
        currentApi.setParamList(currentParamModel.getParamList());
        currentApi.setParamTotalLevel(currentParamModel.getParamTotalLevel());
        currentApi.setParamTotalSize(currentParamModel.getParamTotalSize());
        if (ApiParamTypeEnum.SNAKE_CASE.equals((Object)config.getApiParamType())) {
            currentApi.setJsonExample(ApiParamHelper.getSnakeCaseJson(currentParamModel.getJsonObject()));
        } else {
            currentApi.setJsonExample(ApiJsonFormatUtil.toFormatJson(currentParamModel.getJsonObject()));
        }
        return currentApi;
    }

    private static String getSnakeCaseJson(Object object) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ApiJsonFormatUtil.toFormatJson(object));
    }
}

