/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.util.helper;

import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;

public class ApiMatchAnnoHelper {
    private static final String MIN_SUFFIX = "(min)";

    public static Map<String, JavaAnnotation> getMethodAnnotationMap(JavaMethod method) {
        return ApiMatchAnnoHelper.getAnnotationMap(method.getAnnotations());
    }

    public static Map<String, JavaAnnotation> getParameterAnnotationMap(JavaParameter parameter) {
        return ApiMatchAnnoHelper.getAnnotationMap(parameter.getAnnotations());
    }

    public static Map<String, JavaAnnotation> getFileAnnotationMap(JavaField field) {
        return ApiMatchAnnoHelper.getAnnotationMap(field.getAnnotations());
    }

    private static Map<String, JavaAnnotation> getAnnotationMap(List<JavaAnnotation> annotationList) {
        if (CollectionUtils.isEmpty(annotationList)) {
            return new HashMap<String, JavaAnnotation>(0);
        }
        HashMap<String, JavaAnnotation> annoMap = new HashMap<String, JavaAnnotation>(annotationList.size());
        for (JavaAnnotation annotation : annotationList) {
            annoMap.put(String.valueOf(annotation.getType()), annotation);
        }
        return annoMap;
    }

    public static Integer getRequiredFlagFlag(Map<String, JavaAnnotation> fileAnnotationMap) {
        if (fileAnnotationMap.containsKey("javax.validation.constraints.NotNull")) {
            return 1;
        }
        if (fileAnnotationMap.containsKey("org.hibernate.validator.constraints.NotBlank")) {
            return 1;
        }
        if (fileAnnotationMap.containsKey("org.hibernate.validator.constraints.NotEmpty")) {
            return 1;
        }
        if (fileAnnotationMap.containsKey("javax.validation.constraints.NotEmpty")) {
            return 1;
        }
        if (fileAnnotationMap.containsKey("javax.validation.constraints.NotBlank")) {
            return 1;
        }
        return 0;
    }

    public static Integer getJavaTypeRequired(JavaParameter parameter) {
        Map<String, JavaAnnotation> parameterAnnotationMap = ApiMatchAnnoHelper.getParameterAnnotationMap(parameter);
        if (parameterAnnotationMap.containsKey("org.springframework.web.bind.annotation.RequestParam")) {
            JavaAnnotation annotation = parameterAnnotationMap.get("org.springframework.web.bind.annotation.RequestParam");
            Object required = annotation.getNamedParameter("required");
            if (ObjectUtils.isEmpty((Object)required)) {
                return 1;
            }
            String strRequired = (String)required;
            if ("true".equals(strRequired)) {
                return 1;
            }
        }
        return 0;
    }

    public static String getLength(Map<String, JavaAnnotation> fileAnnotationMap) {
        StringBuilder sizeStr = new StringBuilder();
        boolean mainExistFlag = fileAnnotationMap.containsKey("javax.validation.constraints.Min");
        boolean maxExistFlag = fileAnnotationMap.containsKey("javax.validation.constraints.Max");
        if (mainExistFlag && maxExistFlag) {
            sizeStr.append(ApiMatchAnnoHelper.getAnnoValue(fileAnnotationMap, "javax.validation.constraints.Min"));
            sizeStr.append("-");
            sizeStr.append(ApiMatchAnnoHelper.getAnnoValue(fileAnnotationMap, "javax.validation.constraints.Max"));
            return String.valueOf(sizeStr);
        }
        if (mainExistFlag) {
            sizeStr.append(ApiMatchAnnoHelper.getAnnoValue(fileAnnotationMap, "javax.validation.constraints.Max"));
            if (StringUtils.isNotBlank((CharSequence)sizeStr)) {
                sizeStr.append(MIN_SUFFIX);
            }
            return String.valueOf(sizeStr);
        }
        if (maxExistFlag) {
            sizeStr.append(ApiMatchAnnoHelper.getAnnoValue(fileAnnotationMap, "javax.validation.constraints.Max"));
            return String.valueOf(sizeStr);
        }
        boolean decimalMinExistFlag = fileAnnotationMap.containsKey("javax.validation.constraints.DecimalMin");
        boolean decimalMaxExistFlag = fileAnnotationMap.containsKey("javax.validation.constraints.DecimalMax");
        if (decimalMinExistFlag && decimalMaxExistFlag) {
            sizeStr.append(ApiMatchAnnoHelper.getAnnoValue(fileAnnotationMap, "javax.validation.constraints.DecimalMin"));
            sizeStr.append("-");
            sizeStr.append(ApiMatchAnnoHelper.getAnnoValue(fileAnnotationMap, "javax.validation.constraints.DecimalMax"));
            return String.valueOf(sizeStr);
        }
        if (decimalMinExistFlag) {
            sizeStr.append(ApiMatchAnnoHelper.getAnnoValue(fileAnnotationMap, "javax.validation.constraints.DecimalMin"));
            if (StringUtils.isNotBlank((CharSequence)sizeStr)) {
                sizeStr.append(MIN_SUFFIX);
            }
            return String.valueOf(sizeStr);
        }
        if (decimalMaxExistFlag) {
            sizeStr.append(ApiMatchAnnoHelper.getAnnoValue(fileAnnotationMap, "javax.validation.constraints.DecimalMax"));
            return String.valueOf(sizeStr);
        }
        if (fileAnnotationMap.containsKey("javax.validation.constraints.Size")) {
            return ApiMatchAnnoHelper.getSize(fileAnnotationMap, "javax.validation.constraints.Size");
        }
        if (fileAnnotationMap.containsKey("org.hibernate.validator.constraints.Range")) {
            return ApiMatchAnnoHelper.getSize(fileAnnotationMap, "org.hibernate.validator.constraints.Range");
        }
        if (fileAnnotationMap.containsKey("org.hibernate.validator.constraints.Length")) {
            return ApiMatchAnnoHelper.getSize(fileAnnotationMap, "org.hibernate.validator.constraints.Length");
        }
        return "";
    }

    private static String getAnnoValue(Map<String, JavaAnnotation> fileAnnotationMap, String key) {
        JavaAnnotation maxAnnotation = fileAnnotationMap.get(key);
        if (null != maxAnnotation && null != maxAnnotation.getNamedParameter("value")) {
            return (String)maxAnnotation.getNamedParameter("value");
        }
        return "";
    }

    private static String getSize(Map<String, JavaAnnotation> fileAnnotationMap, String key) {
        boolean maxFlag;
        JavaAnnotation sizeAnno = fileAnnotationMap.get(key);
        if (null == sizeAnno) {
            return "";
        }
        StringBuilder sizeStr = new StringBuilder();
        String minValue = "min";
        String maxValue = "max";
        boolean minFlag = !ObjectUtils.isEmpty((Object)sizeAnno.getNamedParameter(minValue));
        boolean bl = maxFlag = !ObjectUtils.isEmpty((Object)sizeAnno.getNamedParameter(maxValue));
        if (minFlag && maxFlag) {
            sizeStr.append(sizeAnno.getNamedParameter(minValue));
            sizeStr.append("-");
            sizeStr.append(sizeAnno.getNamedParameter(maxValue));
            return String.valueOf(sizeStr);
        }
        if (minFlag) {
            sizeStr.append(sizeAnno.getNamedParameter(minValue));
            if (StringUtils.isNotBlank((CharSequence)sizeStr)) {
                sizeStr.append(MIN_SUFFIX);
            }
            return String.valueOf(sizeStr);
        }
        if (maxFlag) {
            sizeStr.append(sizeAnno.getNamedParameter(maxValue));
            return String.valueOf(sizeStr);
        }
        return "";
    }
}

