/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.util.helper;

import com.alibaba.fastjson.JSON;
import com.fshows.api.generate.core.config.ApiConfig;
import com.fshows.api.generate.core.config.custom.ApiGateWayField;
import com.fshows.api.generate.core.constants.ApiSetConstant;
import com.fshows.api.generate.core.enums.ApiGenerateTypeEnum;
import com.fshows.api.generate.core.enums.ApiParamTypeEnum;
import com.fshows.api.generate.core.exception.ApiGenerateException;
import com.fshows.api.generate.core.model.ApiOutBaseModel;
import com.fshows.api.generate.core.model.ApiOutModel;
import com.fshows.api.generate.core.model.ApiReqParamModel;
import com.fshows.api.generate.core.model.ApiResParamModel;
import com.fshows.api.generate.core.model.ApiWriteModel;
import com.fshows.api.generate.core.util.helper.ApiClassHelper;
import com.fshows.api.generate.core.util.helper.ApiControllerHelper;
import com.fshows.api.generate.core.util.helper.ApiMatchAnnoHelper;
import com.fshows.api.generate.core.util.helper.ApiParamHelper;
import com.fshows.api.generate.core.util.tool.ApiFileNameUtil;
import com.fshows.api.generate.core.util.tool.ApiFilePathUtil;
import com.fshows.api.generate.core.util.tool.ApiLogUtil;
import com.fshows.api.generate.core.util.tool.ApiTemplateUtils;
import com.fshows.api.generate.core.util.tool.ApiWriteUtil;
import com.fshows.api.generate.start.ApiGenerateStart;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaSource;
import freemarker.template.Template;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class ApiGenerateHelper {
    public static void doRun(String projectRootPath, ApiConfig config) {
        JavaProjectBuilder rootPathJavaFile = ApiGenerateHelper.getJavaFileByPath(projectRootPath);
        ApiGenerateHelper.doRunBase(rootPathJavaFile, config);
    }

    public static void doRunXml(ApiConfig config) {
        JavaProjectBuilder rootPathJavaFile = ApiGenerateHelper.getJavaFileByPathList(config.getProjectScanPaths());
        ApiGenerateHelper.doRunBase(rootPathJavaFile, config);
    }

    private static void doRunBase(JavaProjectBuilder rootPathJavaFile, ApiConfig config) {
        long start = System.currentTimeMillis();
        ApiGenerateHelper.buildOtherRootPathJavaFile(rootPathJavaFile, config);
        ApiLogUtil.info("\u626b\u63cf\u5230\u7684\u7c7b\u603b\u6570\u91cf\uff1a{0} , \u626b\u63cf\u8017\u65f6\uff1a{1} ms", rootPathJavaFile.getClasses().size(), System.currentTimeMillis() - start);
        if (rootPathJavaFile.getClasses().size() > 0) {
            String generateFilePath = ApiGenerateTypeEnum.PACKAGE.equals((Object)config.getGenerateType()) ? ApiGenerateHelper.generateByPackage(rootPathJavaFile, ApiGenerateStart.class, config) : ApiGenerateHelper.generateByClass(rootPathJavaFile, config);
            ApiLogUtil.generateEnd();
            ApiLogUtil.info("\u6587\u4ef6\u5730\u5740\uff1a{0}", generateFilePath);
        } else {
            ApiLogUtil.generateEnd();
            ApiLogUtil.warn("\u626b\u63cf\u8def\u5f84\u4e0b\u672a\u626b\u63cf\u5230java\u6587\u4ef6\uff0c\u8bf7\u786e\u8ba4\u626b\u63cf\u8def\u5f84\u662f\u5426\u51c6\u786e !", new Object[0]);
        }
        ApiLogUtil.info("\u6267\u884c\u8017\u65f6\uff1a{0} ms", System.currentTimeMillis() - start);
    }

    public static void checkRequiredConfig(Class runClazz, ApiConfig config) {
        if (null == runClazz) {
            throw new ApiGenerateException("\u53c2\u6570 runClazz \u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (null == config) {
            throw new ApiGenerateException("\u914d\u7f6e ApiConfig \u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (null == config.getGenerateType()) {
            throw new ApiGenerateException("\u751f\u6210\u7c7b\u578b generateType \u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ApiGenerateTypeEnum.PACKAGE.equals((Object)config.getGenerateType()) && StringUtils.isBlank((CharSequence)config.getApiPackage())) {
            throw new ApiGenerateException("\u6839\u636e\u5305\u5730\u5740\u751f\u6210 apiPackage \u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ApiGenerateTypeEnum.CLAZZ.equals((Object)config.getGenerateType()) && CollectionUtils.isEmpty(config.getApiClassNameList())) {
            throw new ApiGenerateException("\u6839\u636e\u7c7b\u751f\u6210 apiClassNameList \u4e0d\u80fd\u4e3a\u7a7a !");
        }
    }

    public static void checkRequiredConfigByXml(ApiConfig config) {
        if (ApiGenerateTypeEnum.PACKAGE.equals((Object)config.getGenerateType()) && StringUtils.isBlank((CharSequence)config.getApiPackagePath())) {
            throw new ApiGenerateException("\u6839\u636e\u5305\u5730\u5740\u751f\u6210 apiPackagePath > value \u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ApiGenerateTypeEnum.CLAZZ.equals((Object)config.getGenerateType()) && CollectionUtils.isEmpty(config.getApiClassPathList())) {
            throw new ApiGenerateException("\u6839\u636e\u7c7b\u751f\u6210 apiClassPaths \u5b50\u96c6 path \u4e0d\u80fd\u4e3a\u7a7a !");
        }
    }

    public static void convertDefaultConfig(String projectRootPath, ApiConfig config) {
        ApiGateWayField gateWayField;
        boolean gateWayAnnotationExistFlag;
        if (StringUtils.isNotBlank((CharSequence)config.getLogLevel())) {
            ApiLogUtil.LEVEL = ApiLogUtil.getLevelByName(config.getLogLevel());
        }
        if (null == config.getGenerateJsonFlag()) {
            config.setGenerateJsonFlag(Boolean.TRUE);
        }
        if (null == config.getConfirmRootPath()) {
            config.setConfirmRootPath(Boolean.TRUE);
        }
        if (StringUtils.isBlank((CharSequence)config.getGenerateFilePath())) {
            config.setGenerateFilePath(config.getGenerateFilePath());
        }
        if (null == config.getGateWayField()) {
            config.setGateWayField(new ApiGateWayField(""));
        }
        if ((gateWayAnnotationExistFlag = StringUtils.isNotBlank((CharSequence)(gateWayField = config.getGateWayField()).getAnnotationName())) && StringUtils.isBlank((CharSequence)gateWayField.getAnnotationFieldName())) {
            config.getGateWayField().setAnnotationFieldName("method");
        }
        if (null == config.getApiParamType()) {
            config.setApiParamType(ApiParamTypeEnum.COMMON);
        }
        if (CollectionUtils.isEmpty(config.getApiExcludeParamNames())) {
            config.setApiExcludeParamNames(new HashSet<String>(0));
        }
    }

    public static JavaProjectBuilder getJavaFileByPathList(List<String> pathList) {
        JavaProjectBuilder rootBuilder = new JavaProjectBuilder();
        rootBuilder.setEncoding("UTF-8");
        if (CollectionUtils.isEmpty(pathList)) {
            return rootBuilder;
        }
        for (String path : pathList) {
            rootBuilder.addSourceTree(new File(path));
        }
        return rootBuilder;
    }

    public static JavaProjectBuilder getJavaFileByPath(String path) {
        JavaProjectBuilder rootBuilder = new JavaProjectBuilder();
        rootBuilder.setEncoding("UTF-8");
        rootBuilder.addSourceTree(new File(path));
        return rootBuilder;
    }

    public static void buildOtherRootPathJavaFile(JavaProjectBuilder rootBuilder, ApiConfig config) {
        if (CollectionUtils.isEmpty(config.getOtherSourceCodePaths())) {
            return;
        }
        for (String filePath : config.getOtherSourceCodePaths()) {
            rootBuilder.addSourceTree(new File(filePath));
            ApiLogUtil.info("\u5176\u5b83\u626b\u63cf\u8def\u5f84\uff1a{0} ", filePath);
        }
    }

    public static String generateByPackage(JavaProjectBuilder rootPathJavaFile, Class runClazz, ApiConfig config) {
        String generatePath = StringUtils.isNotBlank((CharSequence)config.getApiPackagePath()) ? config.getApiPackagePath() : ApiFilePathUtil.getClassProjectPackagePath(runClazz, config.getApiPackage());
        Collection<JavaClass> generateClassList = ApiClassHelper.getClassListByPath(generatePath);
        if (CollectionUtils.isEmpty(generateClassList)) {
            throw new ApiGenerateException("\u6839\u636e\u5305\u5730\u5740\u751f\u6210\u63a5\u53e3\u6587\u6863 , \u5f53\u524d\u5305\u5730\u5740\uff1a{0} , \u5305\u4e0b\u65e0java\u6587\u4ef6\uff01", generatePath);
        }
        if (CollectionUtils.isEmpty(generateClassList)) {
            throw new ApiGenerateException("\u6839\u636e\u5305\u5730\u5740\u751f\u6210\u63a5\u53e3\u6587\u6863 , \u5f53\u524d\u5305\u5730\u5740\uff1a{0} , \u5305\u4e0b\u65e0java\u6587\u4ef6\uff01", generatePath);
        }
        ApiLogUtil.info("\u6839\u636e\u5305\u5730\u5740\u751f\u6210\u63a5\u53e3\u6587\u6863 , \u5f53\u524d\u5305\u5730\u5740\uff1a{0} , \u5305\u4e0b\u7c7b\u6570\u91cf\uff1a{1}", generatePath, generateClassList.size());
        Set<String> paramExcludeSet = ApiGenerateHelper.getExcludeParamFullPathSet(config);
        ArrayList<ApiOutModel> apiOutModelList = new ArrayList<ApiOutModel>();
        int apiSize = 0;
        for (JavaClass clazz : generateClassList) {
            ApiOutModel apiOutModel = ApiGenerateHelper.getApiOutModel(rootPathJavaFile, clazz, paramExcludeSet, config);
            if (null == apiOutModel) continue;
            apiSize += apiOutModel.getApiBaseList().size();
            apiOutModelList.add(apiOutModel);
        }
        if (CollectionUtils.isEmpty(apiOutModelList)) {
            throw new ApiGenerateException("\u6839\u636e\u5305\u5730\u5740\u751f\u6210\u63a5\u53e3\u6587\u6863 , \u5f53\u524d\u5305\u5730\u5740\uff1a{0} , \u65e0\u9700\u8981\u751f\u6210\u7684\u65b9\u6cd5", generatePath);
        }
        ApiLogUtil.info("\u672c\u6b21\u751f\u6210\u53c2\u63a5\u53e3\u603b\u6570\uff1a{0} ", apiSize);
        return ApiGenerateHelper.writeApiFile(apiOutModelList, config);
    }

    public static String generateByClass(JavaProjectBuilder rootPathJavaFile, ApiConfig config) {
        boolean isPathWay = CollectionUtils.isNotEmpty(config.getApiClassPathList());
        List<String> apiClassList = isPathWay ? config.getApiClassPathList() : config.getApiClassNameList();
        ApiLogUtil.info("\u6587\u6863\u751f\u6210\u7c7b\u578b\uff1a\u6839\u636e\u63a5\u53e3\u7c7b\u96c6\u751f\u6210\u63a5\u53e3\u6587\u6863 , \u6570\u91cf\uff1a{0}", apiClassList.size());
        ArrayList<ApiOutModel> apiOutModelList = new ArrayList<ApiOutModel>();
        Set<String> paramExcludeSet = ApiGenerateHelper.getExcludeParamFullPathSet(config);
        int apiSize = 0;
        for (String clazzName : apiClassList) {
            String generatePath;
            if (isPathWay) {
                generatePath = clazzName;
            } else {
                Class<?> aClass = null;
                try {
                    aClass = Class.forName(clazzName);
                }
                catch (Exception e) {
                    throw new ApiGenerateException("\u6839\u636e\u7c7b\u5730\u5740\u751f\u6210\u63a5\u53e3\u6587\u6863 , \u5f53\u524d\u7c7b\u5730\u5740\uff1a{0} , \u83b7\u53d6\u7c7b\u5931\u8d25\uff01", clazzName);
                }
                generatePath = ApiFilePathUtil.getClassProjectJavaPath(aClass, clazzName);
            }
            ApiLogUtil.info("\u751f\u6210\u7c7b\u5730\u5740\uff1a{0} ", generatePath);
            Collection<JavaClass> generateClassList = ApiClassHelper.getClassListByPath(generatePath);
            if (CollectionUtils.isEmpty(generateClassList)) {
                throw new ApiGenerateException("\u6839\u636e\u7c7b\u5730\u5740\u751f\u6210\u63a5\u53e3\u6587\u6863 , \u5f53\u524d\u7c7b\u5730\u5740\uff1a{0} , \u6587\u4ef6\u4e0d\u5b58\u5728\uff01", generatePath);
            }
            for (JavaClass clazz : generateClassList) {
                ApiOutModel apiOutModel = ApiGenerateHelper.getApiOutModel(rootPathJavaFile, clazz, paramExcludeSet, config);
                if (null == apiOutModel) continue;
                apiSize += apiOutModel.getApiBaseList().size();
                apiOutModelList.add(apiOutModel);
            }
        }
        if (CollectionUtils.isEmpty(apiOutModelList)) {
            throw new ApiGenerateException("\u6839\u636e\u7c7b\u5730\u5740\u751f\u6210\u63a5\u53e3\u6587\u6863 ,\u7c7b\u5730\u5740\uff1a{0} \u65e0\u9700\u8981\u751f\u6210\u7684\u65b9\u6cd5", config.getApiClassNameList());
        }
        ApiLogUtil.info("\u672c\u6b21\u751f\u6210\u53c2\u63a5\u53e3\u603b\u6570\uff1a{0} ", apiSize);
        return ApiGenerateHelper.writeApiFile(apiOutModelList, config);
    }

    private static String writeApiFile(List<ApiOutModel> apiOutModelList, ApiConfig config) {
        ApiWriteModel apiWriteModel = new ApiWriteModel();
        apiWriteModel.setParamType(config.getApiParamType().getType());
        apiWriteModel.setLogLevel(ApiLogUtil.LEVEL);
        apiWriteModel.setGenerateJsonFlag(config.getGenerateJsonFlag());
        apiWriteModel.setApiWriteList(apiOutModelList);
        String filePath = ApiGenerateHelper.doWriteApi(config.getGenerateFilePath(), apiWriteModel);
        ApiLogUtil.debug("\u751f\u6210\u7684\u6784\u5efa\u53c2\u6570\uff1a{0} ", JSON.toJSONString((Object)apiWriteModel));
        return filePath;
    }

    private static String doWriteApi(String generateFilePath, ApiWriteModel apiWriteModel) {
        String templateName = "GenerateApi.ftl";
        Template template = ApiTemplateUtils.getTemplate(templateName);
        String filePath = generateFilePath.concat(ApiFileNameUtil.getFileName());
        ApiWriteUtil.write(template, apiWriteModel, filePath);
        return filePath;
    }

    private static ApiOutModel getApiOutModel(JavaProjectBuilder rootBuilder, JavaClass clazz, Set<String> paramExcludeSet, ApiConfig config) {
        String apiRootComment = StringUtils.isBlank((CharSequence)clazz.getComment()) ? clazz.getName() : clazz.getComment();
        String apiRootUrl = ApiControllerHelper.getApiRootUrl(clazz, config);
        String projectRootUrl = ApiControllerHelper.getProjectRootUrl(config);
        List methodList = clazz.getMethods();
        JavaSource javaSource = clazz.getSource();
        ApiLogUtil.info("\u5f53\u524d\u7c7b\uff1a{0} \u63cf\u8ff0\uff1a{1} , Api\u6839\u8def\u5f84\uff1a{2},\u65b9\u6cd5\u6570\u91cf\uff1a{3}", clazz.getGenericFullyQualifiedName(), apiRootComment, apiRootUrl, methodList.size());
        if (CollectionUtils.isEmpty((Collection)methodList)) {
            return null;
        }
        ApiOutBaseModel apiOutBaseModel = null;
        ArrayList<ApiOutBaseModel> apiBaseList = new ArrayList<ApiOutBaseModel>();
        ApiLogUtil.debug(">>>>>>>>>>>>>>> method start >>>>>>>>>>>>>>> ", new Object[0]);
        for (JavaMethod method : methodList) {
            if (method.isPrivate()) {
                ApiLogUtil.warn("\u5f53\u524d\u7c7b\uff1a{0},{1} \u79c1\u6709\u65b9\u6cd5,\u65e0\u9700\u5904\u7406", clazz.getGenericFullyQualifiedName(), method.getName());
                continue;
            }
            apiOutBaseModel = ApiGenerateHelper.buildApiOutBaseModel(rootBuilder, javaSource, method, config, paramExcludeSet, projectRootUrl, apiRootUrl);
            apiBaseList.add(apiOutBaseModel);
        }
        ApiLogUtil.debug(">>>>>>>>>>>>>>> method end >>>>>>>>>>>>>>> ", new Object[0]);
        ApiOutModel apiOutModel = new ApiOutModel();
        apiOutModel.setApiRootTitle(apiRootComment);
        apiOutModel.setApiBaseList(apiBaseList);
        return apiOutModel;
    }

    private static ApiOutBaseModel buildApiOutBaseModel(JavaProjectBuilder rootBuilder, JavaSource javaSource, JavaMethod method, ApiConfig config, Set<String> paramExcludeSet, String projectRootUrl, String apiRootUrl) {
        Map<String, JavaAnnotation> annotationMap = ApiMatchAnnoHelper.getMethodAnnotationMap(method);
        String methodAuthor = ApiGenerateHelper.getMethodAuthor(method);
        ApiLogUtil.debug("\u65b9\u6cd5\u7ed1\u5b9a\u7684\u6ce8\u89e3\uff1a >> {0}", annotationMap);
        String[] methodPathAndType = ApiGenerateHelper.getMethodPathAndType(annotationMap);
        ApiLogUtil.debug("\u65b9\u6cd5\u8bbf\u95ee\u8def\u5f84\u4e0e\u8bbf\u95ee\u7c7b\u578b\uff1a >> {0}", Arrays.asList(methodPathAndType));
        String gateWayApiMethod = ApiGenerateHelper.getGateWayApiMethod(annotationMap, config);
        Set<String> lessPackageSet = ApiGenerateHelper.getLessPackageSet(javaSource);
        ApiReqParamModel reqParam = ApiParamHelper.getReqParam(rootBuilder, lessPackageSet, method, paramExcludeSet, config);
        ApiLogUtil.debug("\u8bf7\u6c42\u53c2\u6570\u8f93\u51fa\uff1a >> {0}", JSON.parseObject((String)JSON.toJSONString((Object)reqParam)));
        ApiResParamModel resParam = ApiParamHelper.getResParam(rootBuilder, lessPackageSet, method, config);
        ApiLogUtil.debug("\u8fd4\u56de\u53c2\u6570\u8f93\u51fa\uff1a >> {0}", JSON.parseObject((String)JSON.toJSONString((Object)resParam)));
        String reqPath = projectRootUrl.concat(apiRootUrl.concat(methodPathAndType[1]));
        String methodComment = StringUtils.isBlank((CharSequence)method.getComment()) ? method.getName() : method.getComment();
        ApiOutBaseModel apiOutBaseModel = new ApiOutBaseModel();
        apiOutBaseModel.setApiTitle(methodComment);
        apiOutBaseModel.setApiAuthor(methodAuthor);
        apiOutBaseModel.setReqParam(reqParam);
        apiOutBaseModel.setResParam(resParam);
        apiOutBaseModel.setReqType(methodPathAndType[0]);
        apiOutBaseModel.setReqPath(reqPath);
        apiOutBaseModel.setGateWayApiMethod(gateWayApiMethod);
        return apiOutBaseModel;
    }

    private static Set<String> getLessPackageSet(JavaSource javaSource) {
        if (CollectionUtils.isEmpty((Collection)javaSource.getImports())) {
            return new HashSet<String>();
        }
        List importNameList = javaSource.getImports();
        HashSet<String> lessPackageSet = new HashSet<String>();
        for (String importClass : importNameList) {
            if (!importClass.endsWith(".*") || ApiSetConstant.STAR_FLOWER_PACKAGE_EXCLUDE_SET.contains(importClass)) continue;
            lessPackageSet.add(importClass);
        }
        return lessPackageSet;
    }

    private static String getGateWayApiMethod(Map<String, JavaAnnotation> annotationMap, ApiConfig config) {
        ApiGateWayField gateWayField = config.getGateWayField();
        if (StringUtils.isBlank((CharSequence)gateWayField.getAnnotationName()) || !annotationMap.containsKey(gateWayField.getAnnotationName())) {
            return "";
        }
        JavaAnnotation annotation = annotationMap.get(gateWayField.getAnnotationName());
        if (null != annotation.getNamedParameter(gateWayField.getAnnotationFieldName())) {
            return String.valueOf(annotation.getNamedParameter(gateWayField.getAnnotationFieldName())).replaceAll("\"", "");
        }
        return "";
    }

    private static String getMethodAuthor(JavaMethod method) {
        List tagList = method.getTags();
        if (CollectionUtils.isEmpty((Collection)tagList)) {
            return "";
        }
        for (DocletTag tag : tagList) {
            if (!"author".equals(tag.getName())) continue;
            return tag.getValue();
        }
        return "";
    }

    private static String[] getMethodPathAndType(Map<String, JavaAnnotation> annotationMap) {
        if (annotationMap.containsKey("org.springframework.web.bind.annotation.RequestMapping")) {
            return ApiGenerateHelper.getReqPath(annotationMap, "org.springframework.web.bind.annotation.RequestMapping", "");
        }
        if (annotationMap.containsKey("org.springframework.web.bind.annotation.GetMapping")) {
            return ApiGenerateHelper.getReqPath(annotationMap, "org.springframework.web.bind.annotation.GetMapping", RequestMethod.GET.name());
        }
        if (annotationMap.containsKey("org.springframework.web.bind.annotation.PostMapping")) {
            return ApiGenerateHelper.getReqPath(annotationMap, "org.springframework.web.bind.annotation.PostMapping", RequestMethod.POST.name());
        }
        if (annotationMap.containsKey("org.springframework.web.bind.annotation.PutMapping")) {
            return ApiGenerateHelper.getReqPath(annotationMap, "org.springframework.web.bind.annotation.PutMapping", RequestMethod.PUT.name());
        }
        if (annotationMap.containsKey("org.springframework.web.bind.annotation.DeleteMapping")) {
            return ApiGenerateHelper.getReqPath(annotationMap, "org.springframework.web.bind.annotation.DeleteMapping", RequestMethod.DELETE.name());
        }
        return new String[]{"POST", ""};
    }

    private static String[] getReqPath(Map<String, JavaAnnotation> annotationMap, String key, String currentReqType) {
        String reqType = "POST";
        String reqPath = "";
        if (annotationMap.containsKey(key)) {
            JavaAnnotation annotation = annotationMap.get(key);
            if (null == annotation) {
                return new String[]{reqType, reqPath};
            }
            if (!ObjectUtils.isEmpty((Object)annotation.getNamedParameter("value"))) {
                reqPath = String.valueOf(annotation.getNamedParameter("value")).replaceAll("\"", "");
            }
            if (!ObjectUtils.isEmpty((Object)annotation.getNamedParameter("method")) && StringUtils.isBlank((CharSequence)currentReqType)) {
                reqType = String.valueOf(annotation.getNamedParameter("method")).replaceAll("\"", "").replaceAll("RequestMethod.", "");
            }
        }
        return new String[]{reqType, reqPath};
    }

    private static Set<String> getExcludeParamFullPathSet(ApiConfig config) {
        HashSet<String> paramExcludeSet = new HashSet<String>(ApiSetConstant.EXCLUDE_PARAM_FULL_PATH_SET);
        if (CollectionUtils.isNotEmpty(config.getApiExcludeParamClassNames())) {
            paramExcludeSet.addAll(config.getApiExcludeParamClassNames());
        }
        return paramExcludeSet;
    }
}

