/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.util.helper;

import com.fshows.api.generate.core.config.ApiConfig;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ApiControllerHelper {
    public static String getApiRootUrl(JavaClass clazz, ApiConfig config) {
        StringBuilder controllerRootUrl = new StringBuilder();
        for (JavaAnnotation annotation : clazz.getAnnotations()) {
            String annotationName = annotation.getType().getName();
            if (!"RequestMapping".equals(annotationName)) continue;
            String baseUrl = annotation.getNamedParameter("value").toString().replaceAll("\"", "");
            if (!baseUrl.startsWith("/")) {
                controllerRootUrl.append("/");
            }
            controllerRootUrl.append(baseUrl);
        }
        return String.valueOf(controllerRootUrl);
    }

    public static String getProjectRootUrl(ApiConfig config) {
        StringBuilder baseUrlBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)config.getProjectRootUrl())) {
            if (!config.getProjectRootUrl().startsWith("/")) {
                baseUrlBuilder.append("/");
            }
            baseUrlBuilder.append(config.getProjectRootUrl());
        }
        return String.valueOf(baseUrlBuilder);
    }

    public static boolean isController(JavaClass clazz) {
        List classAnnotations = clazz.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getName();
            if ("Controller".equals(annotationName)) {
                return true;
            }
            if (!"RestController".equals(annotationName)) continue;
            return true;
        }
        return false;
    }
}

