/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.api.generate.core.config.xml;

import com.alibaba.fastjson.JSON;
import com.fshows.api.generate.core.config.custom.ApiGateWayField;
import com.fshows.api.generate.core.config.custom.ApiRootResField;
import com.fshows.api.generate.core.constants.ApiSetConstant;
import com.fshows.api.generate.core.enums.ApiGenerateTypeEnum;
import com.fshows.api.generate.core.enums.ApiParamTypeEnum;
import com.fshows.api.generate.core.exception.ApiGenerateException;
import com.fshows.api.generate.core.util.tool.ApiJsonFormatUtil;
import com.fshows.api.generate.core.util.tool.ApiLogUtil;
import freemarker.log.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlConfigRead {
    public static Document getDocumentByPath(String configXmlPath) {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new File(configXmlPath));
            Logger.selectLoggerLibrary((int)0);
        }
        catch (FileNotFoundException e1) {
            ApiLogUtil.debug("\u81ea\u52a8\u83b7\u53d6\u914d\u7f6exml\u6587\u4ef6\u5931\u8d25\uff0cstack=", e1);
            return null;
        }
        catch (Exception e) {
            throw new ApiGenerateException("\u5730\u5740: {0} \u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01stack={1}", configXmlPath, e);
        }
        return document;
    }

    public static ApiGenerateTypeEnum getGenerateType(Document document) {
        NodeList propertyList = document.getElementsByTagName("generateType");
        String typeValue = XmlConfigRead.getValue(propertyList, "generateType");
        ApiGenerateTypeEnum typeEnum = ApiGenerateTypeEnum.getGenerateType(typeValue);
        if (ObjectUtils.isEmpty((Object)((Object)typeEnum))) {
            throw new ApiGenerateException("\u751f\u6210\u7c7b\u578b {0}  \u5f53\u524d\u503c {1} \u4e0d\u5b58\u5728 \uff01", "apiParamType", typeValue);
        }
        return typeEnum;
    }

    public static List<String> getProjectScanPaths(Document document) {
        List<String> xmlList = XmlConfigRead.getXmlList(document, "projectScanPaths", "path");
        if (CollectionUtils.isEmpty(xmlList)) {
            throw new ApiGenerateException("\u9879\u76ee\u4e0b\u7c7b\u626b\u63cf\u8def\u5f84 {0} \u5b50\u96c6  {1} \u4e0d\u80fd\u4e3a\u7a7a \uff01", "projectScanPaths", "path");
        }
        return xmlList;
    }

    public static String getApiPackagePath(Document document) {
        NodeList propertyList = document.getElementsByTagName("apiPackagePath");
        return XmlConfigRead.getValue(propertyList, "apiPackagePath");
    }

    public static List<String> getApiClassPaths(Document document) {
        return XmlConfigRead.getXmlList(document, "apiClassPaths", "path");
    }

    public static String getGenerateFilePath(Document document) {
        NodeList propertyList = document.getElementsByTagName("generateFilePath");
        return XmlConfigRead.getValue(propertyList, "generateFilePath");
    }

    public static ApiParamTypeEnum getApiParamType(Document document) {
        NodeList propertyList = document.getElementsByTagName("apiParamType");
        String typeValue = XmlConfigRead.getValue(propertyList, "apiParamType");
        if (StringUtils.isBlank((CharSequence)typeValue)) {
            return ApiParamTypeEnum.COMMON;
        }
        ApiParamTypeEnum typeEnum = ApiParamTypeEnum.getParamType(typeValue);
        if (ObjectUtils.isEmpty((Object)((Object)typeEnum))) {
            throw new ApiGenerateException("\u53c2\u6570\u7c7b\u578b {0}  \u5f53\u524d\u503c {1} \u4e0d\u5b58\u5728 \uff01", "apiParamType", typeValue);
        }
        return typeEnum;
    }

    public static Boolean getGenerateJsonFlag(Document document) {
        NodeList propertyList = document.getElementsByTagName("generateJsonFlag");
        String value = XmlConfigRead.getValue(propertyList, "generateJsonFlag");
        if (StringUtils.isNotBlank((CharSequence)value) && "2".equals(value)) {
            return false;
        }
        return true;
    }

    public static Set<String> getApiExcludeParamNames(Document document) {
        HashSet<String> paramExcludeSet = new HashSet<String>();
        List<String> xmlList = XmlConfigRead.getXmlList(document, "apiExcludeParamNames", "paramName");
        if (CollectionUtils.isNotEmpty(xmlList)) {
            paramExcludeSet.addAll(xmlList);
        }
        return paramExcludeSet;
    }

    public static Set<String> getApiExcludeParamClassNames(Document document) {
        HashSet<String> paramExcludeSet = new HashSet<String>();
        paramExcludeSet.addAll(ApiSetConstant.EXCLUDE_PARAM_FULL_PATH_SET);
        List<String> xmlList = XmlConfigRead.getXmlList(document, "apiExcludeParamClassNames", "paramClassName");
        if (CollectionUtils.isNotEmpty(xmlList)) {
            paramExcludeSet.addAll(xmlList);
        }
        return paramExcludeSet;
    }

    public static String getLogLevel(Document document) {
        NodeList propertyList = document.getElementsByTagName("logLevel");
        return XmlConfigRead.getValue(propertyList, "logLevel");
    }

    public static String getProjectRootUrl(Document document) {
        NodeList propertyList = document.getElementsByTagName("projectRootUrl");
        String value = XmlConfigRead.getValue(propertyList, "projectRootUrl");
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return value;
    }

    public static ApiGateWayField getApiGateWayField(Document document) {
        NodeList propertyList = document.getElementsByTagName("gateWayField");
        if (ObjectUtils.isEmpty((Object)propertyList) || propertyList.getLength() == 0) {
            return new ApiGateWayField("");
        }
        try {
            String annotationName = "";
            String annotationFieldName = "";
            for (int i = 0; i < propertyList.getLength(); ++i) {
                Node table = propertyList.item(i);
                NamedNodeMap attrs = table.getAttributes();
                annotationName = attrs.getNamedItem("annotationName").getNodeValue();
                annotationFieldName = attrs.getNamedItem("annotationFieldName").getNodeValue();
                if (!StringUtils.isBlank((CharSequence)annotationFieldName)) continue;
                annotationFieldName = "method";
            }
            return new ApiGateWayField(annotationName, annotationFieldName);
        }
        catch (Exception e) {
            throw new ApiGenerateException("\u914d\u7f6eXML\u6587\u4ef6 > \u5f00\u653e\u63a5\u53e3\u6ce8\u89e3\u7c7b\u914d\u7f6e \u83b7\u53d6\u5931\u8d25 \uff01");
        }
    }

    public static List<ApiRootResField> getRootRespFieldList(Document document) {
        ArrayList<ApiRootResField> rootRespFieldList = new ArrayList<ApiRootResField>();
        NodeList propertyList = document.getElementsByTagName("apiRootResField");
        if (ObjectUtils.isEmpty((Object)propertyList) || propertyList.getLength() == 0) {
            return rootRespFieldList;
        }
        ApiRootResField resField = null;
        try {
            for (int i = 0; i < propertyList.getLength(); ++i) {
                Element element = (Element)propertyList.item(i);
                NodeList field = element.getElementsByTagName("field");
                if (ObjectUtils.isEmpty((Object)field) || field.getLength() == 0) {
                    return rootRespFieldList;
                }
                for (int j = 0; j < field.getLength(); ++j) {
                    Node item = field.item(j);
                    NamedNodeMap attrs = item.getAttributes();
                    String name = attrs.getNamedItem("name").getNodeValue();
                    String typeClassName = attrs.getNamedItem("typeClassName").getNodeValue();
                    String desc = attrs.getNamedItem("desc").getNodeValue();
                    String isParent = attrs.getNamedItem("isParent").getNodeValue();
                    if (StringUtils.isBlank((CharSequence)name)) {
                        throw new ApiGenerateException("\u914d\u7f6eXML\u6587\u4ef6 > \u914d\u7f6e\u9879 {0} > {1} > {2} \u4e0d\u80fd\u4e3a\u7a7a \uff01", "apiRootResField", "field", "name");
                    }
                    if (StringUtils.isBlank((CharSequence)typeClassName)) {
                        throw new ApiGenerateException("\u914d\u7f6eXML\u6587\u4ef6 > \u914d\u7f6e\u9879 {0} > {1} > {2} \u4e0d\u80fd\u4e3a\u7a7a \uff01", "apiRootResField", "field", "typeClassName");
                    }
                    if (StringUtils.isBlank((CharSequence)desc)) {
                        desc = "";
                    }
                    boolean isParentFlag = false;
                    if (StringUtils.isNotBlank((CharSequence)isParent)) {
                        isParentFlag = "1".equals(isParent);
                    }
                    Class<?> aClass = Class.forName(typeClassName);
                    resField = new ApiRootResField(name, aClass, desc, isParentFlag);
                    rootRespFieldList.add(resField);
                }
            }
        }
        catch (Exception e) {
            throw new ApiGenerateException("\u914d\u7f6eXML\u6587\u4ef6 > {0} \u83b7\u53d6\u5931\u8d25 \uff01stack={1}", "apiRootResField", e);
        }
        return rootRespFieldList;
    }

    private static String getValue(NodeList propertyList, String mess) {
        if (ObjectUtils.isEmpty((Object)propertyList) || propertyList.getLength() == 0) {
            return "";
        }
        String value = "";
        try {
            for (int i = 0; i < propertyList.getLength(); ++i) {
                Node table = propertyList.item(i);
                NamedNodeMap attrs = table.getAttributes();
                value = attrs.getNamedItem("value").getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ApiGenerateException("\u914d\u7f6eXML\u6587\u4ef6 > \u914d\u7f6e\u9879 {0} > value \u83b7\u53d6\u5931\u8d25\u4e86 \uff01", mess);
        }
        return value;
    }

    private static List<String> getXmlList(Document document, String parentTag, String childTag) {
        ArrayList<String> projectPathList = new ArrayList<String>();
        NodeList node = document.getElementsByTagName(parentTag);
        if (ObjectUtils.isEmpty((Object)node) || node.getLength() == 0) {
            return projectPathList;
        }
        for (int i = 0; i < node.getLength(); ++i) {
            Element element = (Element)node.item(i);
            NodeList value = element.getElementsByTagName(childTag);
            if (ObjectUtils.isEmpty((Object)value) || value.getLength() == 0) {
                return projectPathList;
            }
            for (int j = 0; j < value.getLength(); ++j) {
                Node item = value.item(j);
                NamedNodeMap attrs = item.getAttributes();
                String valueStr = attrs.getNamedItem("value").getNodeValue();
                if (StringUtils.isBlank((CharSequence)valueStr)) continue;
                projectPathList.add(valueStr);
            }
        }
        return projectPathList;
    }

    public static void main(String[] args) throws Exception {
        String configXmlPath = "/Users/mengqiang/project/workproject/fshows-api-document-generate/ApiGeneratorConfigV2.xml";
        Document document = XmlConfigRead.getDocumentByPath(configXmlPath);
        ApiGenerateTypeEnum generateType = XmlConfigRead.getGenerateType(document);
        ApiLogUtil.info("generateType : {0}", new Object[]{generateType});
        List<String> projectPaths = XmlConfigRead.getProjectScanPaths(document);
        ApiLogUtil.info("projectPaths : {0}", projectPaths);
        String apiPackagePath = XmlConfigRead.getApiPackagePath(document);
        ApiLogUtil.info("apiPackagePath : {0}", apiPackagePath);
        List<String> apiClassPaths = XmlConfigRead.getApiClassPaths(document);
        ApiLogUtil.info("apiClassPaths : {0}", apiClassPaths);
        String generateFilePath = XmlConfigRead.getGenerateFilePath(document);
        ApiLogUtil.info("generateFilePath : {0}", generateFilePath);
        ApiParamTypeEnum apiParamType = XmlConfigRead.getApiParamType(document);
        ApiLogUtil.info("apiParamType : {0}", new Object[]{apiParamType});
        Boolean generateJsonFlag = XmlConfigRead.getGenerateJsonFlag(document);
        ApiLogUtil.info("generateJsonFlag : {0}", generateJsonFlag);
        Set<String> apiExcludeParamNames = XmlConfigRead.getApiExcludeParamNames(document);
        ApiLogUtil.info("apiExcludeParamNames : {0}", apiExcludeParamNames);
        Set<String> apiExcludeParamClassNames = XmlConfigRead.getApiExcludeParamClassNames(document);
        ApiLogUtil.info("apiExcludeParamClassNames : {0}", apiExcludeParamClassNames);
        String logLevel = XmlConfigRead.getLogLevel(document);
        ApiLogUtil.info("logLevel : {0}", logLevel);
        String projectRootUrl = XmlConfigRead.getProjectRootUrl(document);
        ApiLogUtil.info("projectRootUrl : {0}", projectRootUrl);
        ApiGateWayField apiGateWayField = XmlConfigRead.getApiGateWayField(document);
        ApiLogUtil.info("apiGateWayField : {0}", JSON.toJSONString((Object)apiGateWayField));
        List<ApiRootResField> rootRespFieldList = XmlConfigRead.getRootRespFieldList(document);
        ApiLogUtil.info("rootRespFieldList : {0}", ApiJsonFormatUtil.toFormatJson(rootRespFieldList));
    }
}

