/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.start;

import com.alibaba.fastjson.JSON;
import com.fshow.api.generate.core.config.ConfigXmlReadUtil;
import com.fshow.api.generate.core.enums.GenerateTypeEnum;
import com.fshow.api.generate.core.exception.ApiGenerateException;
import com.fshow.api.generate.core.model.ApiBatchOutModel;
import com.fshow.api.generate.core.model.ApiOutModel;
import com.fshow.api.generate.core.util.biz.ApiParamUtil;
import com.fshow.api.generate.core.util.biz.ApiSupportUtil;
import com.fshow.api.generate.core.util.tool.ApiClassUtil;
import com.fshow.api.generate.core.util.tool.ApiFileNameUtil;
import com.fshow.api.generate.core.util.tool.ApiWriteUtil;
import com.fshow.api.generate.core.util.tool.FreeMarkerTemplateUtils;
import freemarker.template.Configuration;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.w3c.dom.Document;

public class ApiGenerateStart {
    public static void run() {
        Scanner scanner = new Scanner(System.in);
        System.out.println();
        System.out.println("********************** ^_^ \u63a5\u53e3\u6587\u6863\u751f\u6210\u5f00\u59cb ^_^ **********************");
        System.out.println(">>> \u8bf7\u8f93\u5165\u63a5\u53e3\u751f\u6210\u5de5\u5177\u914d\u7f6e\u6587\u4ef6\u4f4d\u7f6e\uff1a");
        String configXmlPath = scanner.nextLine();
        ApiGenerateStart.generateApi(configXmlPath);
    }

    public static void run(String configXmlPath) {
        System.out.println();
        System.out.println("********************** ^_^ \u63a5\u53e3\u6587\u6863\u751f\u6210\u5f00\u59cb ^_^ **********************");
        System.out.println();
        ApiGenerateStart.generateApi(configXmlPath);
    }

    private static void generateApi(String configXmlPath) {
        if (StringUtils.isBlank((CharSequence)configXmlPath)) {
            System.err.println(">>> \u6267\u884c\u5931\u8d25 => \u539f\u56e0\uff1a\u914d\u7f6e\u6587\u4ef6\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a \uff01\uff01\uff01");
            return;
        }
        long start = System.currentTimeMillis();
        System.out.println(MessageFormat.format(">>> \u914d\u7f6e\u6587\u4ef6\u5730\u5740\uff1a{0}", configXmlPath));
        try {
            Document document = ConfigXmlReadUtil.getDocument(configXmlPath);
            Map<String, String> srcMappingMap = ConfigXmlReadUtil.getSrcMappingMap(document);
            String generateFilePath = ConfigXmlReadUtil.getGenerateFilePath(document);
            String generateType = ConfigXmlReadUtil.getGenerateType(document);
            Boolean generateTypeExistFlag = GenerateTypeEnum.isGenerateType(generateType);
            if (!generateTypeExistFlag.booleanValue()) {
                throw new ApiGenerateException(">>> \u751f\u6210\u7c7b\u578b generateType > value \u5f53\u524d\u503c\u4e0d\u5b58\u5728,\u53d6\u503c\u8303\u56f4\u53ea\u80fd\u4e3a {0} \uff01", GenerateTypeEnum.getAllType());
            }
            System.out.println(">>> \u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u5b8c\u6210");
            String resultFilePath = null;
            if (GenerateTypeEnum.PACKAGE.getType().equals(generateType)) {
                System.out.println(">>> \u6587\u6863\u751f\u6210\u7c7b\u578b\uff1a\u6839\u636e\u5305\u5730\u5740\u751f\u6210\u63a5\u53e3\u6587\u6863");
                String apiPackage = ConfigXmlReadUtil.getApiPackage(document);
                Set<Class<?>> packageClassSet = ApiClassUtil.getClassSet(apiPackage);
                if (CollectionUtils.isEmpty(packageClassSet)) {
                    throw new ApiGenerateException(">>> \u5305\u5730\u5740\uff1a{0}, \u4e0d\u5b58\u5728\uff0c\u6216\u5305\u4e0b\u65e0\u6587\u4ef6\uff01", apiPackage);
                }
                resultFilePath = ApiGenerateStart.doGenerate(document, srcMappingMap, packageClassSet, generateFilePath);
            } else if (GenerateTypeEnum.CLAZZ.getType().equals(generateType)) {
                System.out.println(">>> \u6587\u6863\u751f\u6210\u7c7b\u578b\uff1a\u6839\u636e\u7c7b\u5730\u5740\u751f\u6210\u63a5\u53e3\u6587\u6863");
                Set<Class<?>> classSet = ConfigXmlReadUtil.getApiClassPackages(document);
                resultFilePath = ApiGenerateStart.doGenerate(document, srcMappingMap, classSet, generateFilePath);
            }
            long end = System.currentTimeMillis();
            System.out.println();
            System.out.println("********************** ^_^ \u63a5\u53e3\u6587\u6863\u751f\u6210\u7ed3\u675f ^_^ **********************");
            System.out.println();
            System.out.println(MessageFormat.format(">>> \u6587\u4ef6\u5730\u5740\uff1a{0}", resultFilePath));
            System.out.println(MessageFormat.format(">>> \u6267\u884c\u8017\u65f6\uff1a{0} ms", end - start));
        }
        catch (Exception e) {
            System.out.println();
            System.err.println("********************** T_T \u63a5\u53e3\u6587\u6863\u751f\u6210\u5931\u8d25 T_T **********************");
            System.out.println();
            if (e instanceof ApiGenerateException) {
                System.err.println(MessageFormat.format(">>> \u5931\u8d25\u539f\u56e0\uff1a {0}", e.getMessage()));
            }
            System.err.println(MessageFormat.format(">>> \u5931\u8d25\u539f\u56e0\uff1a \u5176\u5b83\u5f02\u5e38 stack={0}", ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    private static String doGenerate(Document document, Map<String, String> srcMappingMap, Set<Class<?>> classSet, String generateFilePath) throws Exception {
        ApiBatchOutModel batchOutModel = new ApiBatchOutModel();
        batchOutModel.setParamType(ConfigXmlReadUtil.getParamNameType(document));
        ArrayList<ApiOutModel> apiOutModelList = new ArrayList<ApiOutModel>();
        int apiTotalSize = 0;
        for (Class<?> clazz : classSet) {
            if (ApiSupportUtil.isSpringBootTest(clazz).booleanValue()) {
                System.out.println(MessageFormat.format(">>> \u5f53\u524d\u63a5\u53e3\u7c7b\uff1a{0} -> \u4e3aSpringBoot\u6d4b\u8bd5\u7c7b,\u5df2\u81ea\u52a8\u8fc7\u6ee4", clazz.getName()));
                continue;
            }
            ApiOutModel apiOutModel = ApiSupportUtil.geApiOutModel(document, srcMappingMap, clazz.getName());
            if (null == apiOutModel) continue;
            ApiParamUtil.doProcessApiOutModel(apiOutModel);
            System.out.println(MessageFormat.format(">>> \u63a5\u53e3\u7c7b\u751f\u6210\u60c5\u51b5\uff1a{0} , \u63cf\u8ff0\uff1a{1} , \u63a5\u53e3\u6570\u91cf\uff1a{2}", clazz.getName(), apiOutModel.getApiParentDesc(), apiOutModel.getApiBaseList().size()));
            System.out.println();
            apiOutModelList.add(apiOutModel);
            apiTotalSize += apiOutModel.getApiBaseList().size();
        }
        batchOutModel.setGenerateJsonDemo(ConfigXmlReadUtil.getJsonFlag(document));
        batchOutModel.setApiOutModelList(apiOutModelList);
        System.out.println(MessageFormat.format(">>> \u751f\u6210\u63a5\u53e3\u603b\u6570\uff1a{0}", apiTotalSize));
        Boolean showLogFlag = ConfigXmlReadUtil.getShowLogFlag(document);
        if (showLogFlag.booleanValue()) {
            System.out.println(">>> \u751f\u6210\u6587\u6863\u5185\u5bb9\u8f93\u51fa\uff1a");
            System.out.println(JSON.toJSONString((Object)batchOutModel));
            System.out.println();
        }
        return ApiGenerateStart.doWriteApi(generateFilePath, batchOutModel);
    }

    private static String doWriteApi(String generateFilePath, ApiBatchOutModel batchOutModel) throws Exception {
        Configuration cfg = FreeMarkerTemplateUtils.getConfiguration();
        String filePath = generateFilePath.concat(ApiFileNameUtil.getFileName());
        String ftlName = "GenerateApiV2.ftl";
        ApiWriteUtil.write(cfg, ftlName, batchOutModel, filePath);
        return filePath;
    }
}

