/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.core.util.tool;

public class TypeMatchUtil {
    public static boolean isJavaClass(String genericType) {
        return genericType.contains("java.");
    }

    public static boolean isArray(String genericType) {
        return genericType.contains("[]");
    }

    public static boolean isObject(String genericType) {
        return genericType.contains("Object");
    }

    public static boolean isObjectTClass(String genericType) {
        return genericType.contains("<") && genericType.contains(">");
    }

    public static boolean isTClass(String genericType) {
        return genericType.contains("<T>");
    }

    public static boolean isSelfClass(String genericType) {
        try {
            Class<?> paramClazz = Class.forName(genericType);
            return null != paramClazz;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isList(String genericType) {
        return genericType.contains("List");
    }

    public static boolean isSet(String genericType) {
        return genericType.contains("Set");
    }

    public static boolean isApiMethodImpl(String content) {
        return content.contains("public") && content.contains("{");
    }

    public static boolean isApiInterface(String content) {
        return content.contains("(") && content.contains(")") && content.contains(";");
    }

    public static boolean isApiInterfaceMethod(String content) {
        return content.contains("(") && content.contains(")") && content.contains(" ");
    }
}

