/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.core.util.tool;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MatcherUtil {
    private static final String IS_CHINESE_PATTERN = "[\u4e00-\u9fa5]";

    public static boolean isContainChinese(String str) {
        Pattern p = Pattern.compile(IS_CHINESE_PATTERN);
        Matcher m = p.matcher(str);
        return m.find();
    }

    public static boolean isBeanField(String str) {
        if (str.contains("private") && 3 == str.split(" ").length) {
            return true;
        }
        if (str.contains("protected") && 3 == str.split(" ").length) {
            return true;
        }
        return str.contains("public") && 3 == str.split(" ").length;
    }

    public static String getBeanField(String str) {
        return str.split(" ")[2];
    }

    public static String[] getTArrayByField(Field field) {
        if (null == field) {
            return new String[0];
        }
        Type genericFieldType = field.getGenericType();
        if (genericFieldType instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)genericFieldType;
            Type[] fieldArgTypes = aType.getActualTypeArguments();
            Type fieldArgType = fieldArgTypes[0];
            return fieldArgType.getTypeName().replaceAll(">", "").split("<");
        }
        return new String[0];
    }

    public static String[] getTArrayByMethod(Method method) {
        if (null == method) {
            return new String[0];
        }
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType aType = (ParameterizedType)genericReturnType;
            Type[] fieldArgTypes = aType.getActualTypeArguments();
            String typeNames = fieldArgTypes[0].getTypeName();
            return typeNames.replaceAll(">", "").split("<");
        }
        return new String[0];
    }

    public static String getTypeFieldByPackage(String str) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            String[] split = str.split("\\.");
            return split[split.length - 1];
        }
        return "";
    }

    public static String stringValueOf(String str) {
        return str == null ? "" : str;
    }

    public static String replaceBrackets(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        String content = str.replaceAll("\\(", "").replaceAll("\\)", "");
        return content;
    }

    public static String filterChinese(String str) {
        String result = str;
        boolean flag = MatcherUtil.isContainChinese(str);
        if (flag) {
            StringBuffer sb = new StringBuffer();
            boolean flag2 = false;
            char chinese = '\u0000';
            char[] charArray = str.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                chinese = charArray[i];
                flag2 = MatcherUtil.isChinese(chinese);
                if (flag2) continue;
                sb.append(chinese);
            }
            result = sb.toString();
        }
        return result;
    }

    public static boolean isChineseChar(char c) {
        try {
            return String.valueOf(c).getBytes("UTF-8").length > 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static char validateLegalString(String content) {
        String illegal = "`~!#%^&*=+\\|{};:'\",<>/?\u25cb\u25cf\u2605\u2606\u2609\u2640\u2642\u203b\u00a4\u256c\u306e\u3006";
        char isLegalChar = 't';
        block0: for (int i = 0; i < content.length(); ++i) {
            for (int j = 0; j < illegal.length(); ++j) {
                if (content.charAt(i) != illegal.charAt(j)) continue;
                isLegalChar = content.charAt(i);
                break block0;
            }
        }
        return isLegalChar;
    }

    public static boolean isRightChar(char c) {
        return MatcherUtil.isChinese(c) || MatcherUtil.isWord(c);
    }

    public static boolean isWord(char c) {
        String regEx = "[\\w]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher("" + c);
        return m.matches();
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean checkNameChese(String name) {
        boolean res = true;
        char[] cTemp = name.toCharArray();
        for (int i = 0; i < name.length(); ++i) {
            if (MatcherUtil.isChinese(cTemp[i])) continue;
            res = false;
            break;
        }
        return res;
    }
}

