/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.core.util.tool;

import com.fshow.api.generate.core.exception.ApiGenerateException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class ApiWriteUtil {
    private static final String CHAR_SET = "UTF-8";

    public static void write(Configuration cfg, String ftlName, Object data, String destFilePath) throws Exception {
        try {
            boolean flag;
            File destFile = new File(destFilePath);
            ApiWriteUtil.generateFolder(destFile.getParent());
            if (!destFile.exists() && !(flag = destFile.createNewFile())) {
                throw new ApiGenerateException("\u6587\u4ef6\u65e0\u6cd5\u88ab\u521b\u5efa");
            }
        }
        catch (IOException e) {
            throw new ApiGenerateException("\u6587\u4ef6\u5199\u51fa\u5f02\u5e38,\u5199\u51fa\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u6587\u4ef6\u65e0\u6cd5\u88ab\u521b\u5efa\uff01");
        }
        Template template = cfg.getTemplate(ftlName, CHAR_SET);
        template.setEncoding(CHAR_SET);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(destFilePath), CHAR_SET);
        template.process(data, (Writer)out);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    private static void generateFolder(String folderPath) {
        File folder = new File(folderPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }
}

