/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.core.util.tool;

import com.fshow.api.generate.core.exception.ApiGenerateException;
import java.io.File;
import java.io.FileFilter;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApiClassUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiClassUtil.class);
    private static final String FILE_STR = "file";
    private static final String JAR_STR = "jar";
    private static final String CLASS_SUFFIX = ".class";

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(String className, boolean isInitialized) {
        Class<?> cls;
        try {
            cls = Class.forName(className, isInitialized, ApiClassUtil.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("load class failure", (Throwable)e);
            throw new RuntimeException(e);
        }
        return cls;
    }

    public static Class<?> loadClass(String className) {
        return ApiClassUtil.loadClass(className, true);
    }

    public static Set<Class<?>> getClassSet(String packageName) {
        HashSet classSet = new HashSet();
        try {
            Enumeration<URL> urls = ApiClassUtil.getClassLoader().getResources(packageName.replace(".", "/"));
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url == null) continue;
                String protocol = url.getProtocol();
                if (FILE_STR.equals(protocol)) {
                    ApiClassUtil.doGetFromFile(url, classSet, packageName);
                    continue;
                }
                if (!JAR_STR.equals(protocol)) continue;
                ApiClassUtil.doGetFromJar(url, classSet, packageName);
            }
        }
        catch (Exception e) {
            throw new ApiGenerateException(">>> \u83b7\u53d6\u5305\u4e0b\u6240\u6709\u7c7b\u6267\u884c\u5f02\u5e38 stack ={0}", ExceptionUtils.getStackTrace((Throwable)e));
        }
        return classSet;
    }

    private static void doGetFromFile(URL url, Set<Class<?>> classSet, String packageName) {
        String packagePath = url.getPath().replaceAll("%20", " ");
        ApiClassUtil.addClass(classSet, packagePath, packageName);
    }

    private static void doGetFromJar(URL url, Set<Class<?>> classSet, String packageName) throws Exception {
        JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
        if (jarURLConnection == null) {
            return;
        }
        JarFile jarFile = jarURLConnection.getJarFile();
        if (jarFile == null) {
            return;
        }
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            String jarEntryName = jarEntry.getName();
            if (!jarEntryName.endsWith(CLASS_SUFFIX)) continue;
            String className = jarEntryName.substring(0, jarEntryName.lastIndexOf("")).replaceAll("/", ".");
            ApiClassUtil.doAddClass(classSet, className);
        }
    }

    private static void addClass(Set<Class<?>> classSet, String packagePath, String packageName) {
        File[] files;
        for (File file : files = new File(packagePath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(ApiClassUtil.CLASS_SUFFIX) || file.isDirectory();
            }
        })) {
            String fileName = file.getName();
            if (file.isFile()) {
                String className = fileName.substring(0, fileName.lastIndexOf("."));
                if (StringUtils.isNotEmpty((CharSequence)packageName)) {
                    className = packageName + "." + className;
                }
                ApiClassUtil.doAddClass(classSet, className);
                continue;
            }
            String subPackagePath = fileName;
            if (StringUtils.isNotEmpty((CharSequence)packagePath)) {
                subPackagePath = packagePath + "/" + subPackagePath;
            }
            String subPackageName = fileName;
            if (StringUtils.isNotEmpty((CharSequence)packageName)) {
                subPackageName = packageName + "." + subPackageName;
            }
            ApiClassUtil.addClass(classSet, subPackagePath, subPackageName);
        }
    }

    private static void doAddClass(Set<Class<?>> classSet, String className) {
        Class<?> cls = ApiClassUtil.loadClass(className, false);
        classSet.add(cls);
    }
}

