/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.core.util.biz;

import com.fshow.api.generate.core.constant.CommonConstant;
import com.fshow.api.generate.core.model.ApiDescModel;
import com.fshow.api.generate.core.util.biz.ApiSupportUtil;
import com.fshow.api.generate.core.util.tool.ApiFilePathUtil;
import com.fshow.api.generate.core.util.tool.ApiStrReplaceUtil;
import com.fshow.api.generate.core.util.tool.MatcherUtil;
import com.fshow.api.generate.core.util.tool.TypeMatchUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ReadMethodNoteUtil {
    public static Map<String, ApiDescModel> readMethodNoteMap(Map<String, String> srcPathMap, String classPackageName) {
        if (MapUtils.isEmpty(srcPathMap) || StringUtils.isBlank((CharSequence)classPackageName)) {
            return new HashMap<String, ApiDescModel>(0);
        }
        Map<String, List<String>> methodMap = ReadMethodNoteUtil.readMethodMap(srcPathMap, classPackageName);
        return ReadMethodNoteUtil.buildResultMethodMap(methodMap);
    }

    private static Map<String, List<String>> readMethodMap(Map<String, String> srcPathMap, String classPackageName) {
        HashMap<String, List<String>> methodMap = new HashMap<String, List<String>>(64);
        String srcPath = ApiSupportUtil.getSrcPath(srcPathMap, classPackageName);
        if (StringUtils.isBlank((CharSequence)srcPath)) {
            System.err.println(MessageFormat.format(">>> \u83b7\u53d6\u65b9\u6cd5\u6ce8\u91ca\u544a\u8b66 >> \u5f53\u524d\u7c7b : {0} , \u6240\u5c5e src \u5730\u5740\u4e0d\u5b58\u5728 \uff01\uff01\uff01", classPackageName));
            return methodMap;
        }
        String javaFilePath = ApiFilePathUtil.getJavaPathBySrcAndPackage(srcPath, classPackageName);
        try {
            Class<?> aClass = Class.forName(classPackageName);
            if (!ReadMethodNoteUtil.isHasMethods(aClass).booleanValue()) {
                System.out.println(MessageFormat.format(">>> \u5f53\u524d\u7c7b\uff1a{0} -> \u4e0d\u5b58\u5728\u53ef\u64cd\u4f5c\u7684\u65b9\u6cd5,\u5df2\u81ea\u52a8\u8fc7\u6ee4", classPackageName));
                return methodMap;
            }
            File file = new File(javaFilePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CommonConstant.DEFAULT_CHARSET));
            int mapLine = 0;
            String lineContent = reader.readLine();
            ArrayList<String> commentList = null;
            while (lineContent != null) {
                String key;
                String content = lineContent.trim();
                if (ReadMethodNoteUtil.isComment(lineContent).booleanValue()) {
                    if (content.startsWith("/")) {
                        commentList = new ArrayList<String>();
                    }
                    if (null == commentList) continue;
                    if (content.length() > 1) {
                        commentList.add(content.replaceAll(";", ""));
                    }
                    if (lineContent.trim().endsWith("/")) {
                        key = classPackageName.concat(String.valueOf(++mapLine));
                        methodMap.put(key, commentList);
                    }
                } else if (TypeMatchUtil.isApiMethodImpl(content) || TypeMatchUtil.isApiInterface(content)) {
                    key = classPackageName.concat(String.valueOf(mapLine));
                    if (methodMap.containsKey(key)) {
                        ((List)methodMap.get(key)).add(content.replaceAll(";", ""));
                    }
                    ++mapLine;
                }
                lineContent = reader.readLine();
            }
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format("\u5f53\u524d\u7c7b : {0},src-path : {1},\u8bfb\u53d6\u65b9\u6cd5\u6587\u6863\u6ce8\u91ca\u5f02\u5e38 stack ={2} ", classPackageName, srcPath, ExceptionUtils.getStackTrace((Throwable)e)));
        }
        return methodMap;
    }

    private static Boolean isComment(String content) {
        return content.contains("/*") || content.contains("*") && !content.contains("import");
    }

    private static Map<String, ApiDescModel> buildResultMethodMap(Map<String, List<String>> methodMap) {
        if (MapUtils.isEmpty(methodMap)) {
            return new HashMap<String, ApiDescModel>(0);
        }
        HashMap<String, ApiDescModel> resultMap = new HashMap<String, ApiDescModel>(64);
        for (Map.Entry<String, List<String>> map : methodMap.entrySet()) {
            ApiDescModel apiDescModel;
            List<String> valueList = map.getValue();
            if (CollectionUtils.isEmpty(valueList)) continue;
            StringBuilder authorStr = new StringBuilder();
            StringBuilder commentStr = new StringBuilder();
            String methodName = "";
            for (String str : valueList) {
                String content = ApiStrReplaceUtil.replaceContent(str);
                if (StringUtils.isBlank((CharSequence)content)) continue;
                if (content.startsWith("public") && !content.contains("class") && content.contains("{")) {
                    methodName = ReadMethodNoteUtil.getMethodName(content);
                } else if (TypeMatchUtil.isApiInterfaceMethod(content)) {
                    methodName = ReadMethodNoteUtil.getMethodName(content);
                }
                if (content.contains("@author")) {
                    authorStr.append(content.replaceAll("@author", ""));
                }
                if (!content.contains("@") && MatcherUtil.isContainChinese(content)) {
                    commentStr.append(content);
                }
                if (!content.contains("@version") || !content.contains(".java")) continue;
                commentStr.append("controller_name_key.");
            }
            String author = String.valueOf(authorStr);
            String comment = String.valueOf(commentStr);
            if (comment.contains("controller_name_key.")) {
                apiDescModel = new ApiDescModel();
                apiDescModel.setApiName(methodName == null ? "" : methodName);
                apiDescModel.setAuthor(author == null ? "" : author);
                apiDescModel.setDescription(comment.replaceAll("controller_name_key.", ""));
                resultMap.put("controller_name_key.", apiDescModel);
                continue;
            }
            if (StringUtils.isBlank((CharSequence)methodName)) continue;
            apiDescModel = new ApiDescModel();
            apiDescModel.setApiName(methodName);
            apiDescModel.setAuthor(author == null ? "" : author);
            apiDescModel.setDescription(comment);
            resultMap.put(methodName, apiDescModel);
        }
        return resultMap;
    }

    private static String getMethodName(String content) {
        String[] split;
        String methodName = "";
        for (String s : split = content.replaceAll("\\{", "").split(" ")) {
            if (!s.contains("(")) continue;
            int index = s.indexOf("(");
            methodName = s.substring(0, index);
            break;
        }
        return methodName;
    }

    private static Boolean isHasMethods(Class<?> aClass) {
        if (null == aClass) {
            return false;
        }
        if (aClass.getDeclaredMethods().length <= 0) {
            return false;
        }
        boolean hasMethodFlag = false;
        for (Method method : aClass.getDeclaredMethods()) {
            if ("main".equals(method.getName())) continue;
            hasMethodFlag = true;
            break;
        }
        return hasMethodFlag;
    }
}

