/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.core.util.biz;

import com.fshow.api.generate.core.constant.CommonConstant;
import com.fshow.api.generate.core.util.biz.ApiSupportUtil;
import com.fshow.api.generate.core.util.tool.ApiFilePathUtil;
import com.fshow.api.generate.core.util.tool.ApiStrReplaceUtil;
import com.fshow.api.generate.core.util.tool.MatcherUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ReadClassNoteUtil {
    public static Map<String, String> readClassNoteMap(Map<String, String> srcPathMap, String classPackageName) {
        if (MapUtils.isEmpty(srcPathMap) || StringUtils.isBlank((CharSequence)classPackageName)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, List<String>> fieldMap = new HashMap<String, List<String>>(64);
        ReadClassNoteUtil.readFieldMap(srcPathMap, classPackageName, fieldMap);
        return ReadClassNoteUtil.readClassMap(fieldMap);
    }

    private static Map<String, String> readClassMap(Map<String, List<String>> fieldMap) {
        if (MapUtils.isEmpty(fieldMap)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> beanMap = new HashMap<String, String>(64);
        for (Map.Entry<String, List<String>> map : fieldMap.entrySet()) {
            List<String> valueList = map.getValue();
            if (CollectionUtils.isEmpty(valueList)) continue;
            String fieldName = "";
            StringBuilder commentStr = new StringBuilder();
            for (String str : valueList) {
                String content = ApiStrReplaceUtil.replaceContent(str);
                if (StringUtils.isBlank((CharSequence)content)) continue;
                if (MatcherUtil.isBeanField(content)) {
                    fieldName = MatcherUtil.getBeanField(content);
                }
                if (content.contains("@") || !MatcherUtil.isContainChinese(content)) continue;
                commentStr.append(content);
            }
            if (StringUtils.isBlank((CharSequence)fieldName)) continue;
            beanMap.put(fieldName, String.valueOf(commentStr));
        }
        return beanMap;
    }

    private static void readFieldMap(Map<String, String> srcPathMap, String classPackageName, Map<String, List<String>> fieldMap) {
        String srcPath = ApiSupportUtil.getSrcPath(srcPathMap, classPackageName);
        if (StringUtils.isBlank((CharSequence)srcPath)) {
            System.err.println(MessageFormat.format(">>> \u83b7\u53d6\u5c5e\u6027\u6ce8\u91ca\u544a\u8b66 >> \u5f53\u524d\u7c7b : {0} ,\u6240\u5c5e src \u5730\u5740\u4e0d\u5b58\u5728 \uff01\uff01\uff01", classPackageName));
            return;
        }
        try {
            Class<?> aClass = Class.forName(classPackageName);
            String javaFilePath = ApiFilePathUtil.getJavaPathBySrcAndPackage(srcPath, classPackageName);
            String basePackage = aClass.getPackage().getName();
            if (aClass.getDeclaredFields().length <= 0) {
                System.out.println(MessageFormat.format(">>> \u5f53\u524d\u7c7b\uff1a{0} -> \u65e0\u5c5e\u6027,\u5df2\u81ea\u52a8\u8fc7\u6ee4", classPackageName));
                return;
            }
            File file = new File(javaFilePath);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), CommonConstant.DEFAULT_CHARSET));
            String lineContent = reader.readLine();
            int mapLine = 0;
            HashMap<String, String> importMap = new HashMap<String, String>(64);
            ArrayList<String> commentList = null;
            String parentClassName = null;
            while (lineContent != null) {
                String content = lineContent.trim().replaceAll(";", "");
                if (lineContent.contains("/*") || lineContent.contains("*")) {
                    if (content.startsWith("/")) {
                        commentList = new ArrayList<String>();
                    }
                    if (null == commentList) continue;
                    if (content.length() > 1) {
                        commentList.add(content);
                    }
                    if (content.endsWith("/") && CollectionUtils.isNotEmpty(commentList)) {
                        String key = classPackageName.concat(String.valueOf(++mapLine));
                        fieldMap.put(key, commentList);
                    }
                } else if (content.startsWith("import")) {
                    ReadClassNoteUtil.doBuildImportMap(content, importMap);
                } else if (content.contains("extends")) {
                    parentClassName = ReadClassNoteUtil.getParentClassName(content);
                } else if (content.startsWith("private") || content.startsWith("protected")) {
                    ReadClassNoteUtil.doBuildFiledMap(content, classPackageName, mapLine, fieldMap);
                    ++mapLine;
                }
                lineContent = reader.readLine();
            }
            if (StringUtils.isNotBlank(parentClassName)) {
                parentClassName = ApiStrReplaceUtil.replaceMaxBracket(parentClassName);
                String parentPackage = ReadClassNoteUtil.getParentPackage(importMap, parentClassName, basePackage);
                ReadClassNoteUtil.readFieldMap(srcPathMap, parentPackage, fieldMap);
            }
        }
        catch (Exception e) {
            System.err.println(MessageFormat.format("\u5f53\u524d\u7c7b : {0},src-path : {1},\u8bfb\u53d6\u6587\u6863\u6ce8\u91ca\u5f02\u5e38 stack ={2} ", classPackageName, srcPath, ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    private static void doBuildImportMap(String content, Map<String, String> importMap) {
        String[] split = content.split("\\.");
        String key = split[split.length - 1];
        String packageValue = content.replaceAll("import", "").replaceAll(" ", "");
        importMap.put(key, packageValue);
    }

    private static String getParentClassName(String content) {
        String[] split = content.split(" ");
        if (null == split || split.length == 0) {
            return null;
        }
        int extendsSize = 0;
        for (String s : split) {
            ++extendsSize;
            if (s.contains("extends")) break;
        }
        return split[extendsSize];
    }

    private static String getParentPackage(Map<String, String> importMap, String parentClassName, String basePackage) {
        String extendsClassBasePackage = importMap.get(parentClassName);
        if (StringUtils.isBlank((CharSequence)extendsClassBasePackage)) {
            extendsClassBasePackage = basePackage.concat(".").concat(parentClassName);
        }
        return extendsClassBasePackage;
    }

    private static void doBuildFiledMap(String content, String packagePath, int mapLine, Map<String, List<String>> fieldMap) {
        String key = packagePath.concat(String.valueOf(mapLine));
        if (!fieldMap.containsKey(key)) {
            return;
        }
        fieldMap.get(key).add(content);
    }
}

