/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.core.util.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshow.api.generate.core.config.ConfigXmlReadUtil;
import com.fshow.api.generate.core.config.model.OpenApiConfigModel;
import com.fshow.api.generate.core.constant.SetConstant;
import com.fshow.api.generate.core.enums.ApiParamTypeEnum;
import com.fshow.api.generate.core.exception.ApiGenerateException;
import com.fshow.api.generate.core.model.ApiDescModel;
import com.fshow.api.generate.core.model.ApiOutBaseModel;
import com.fshow.api.generate.core.model.ApiOutModel;
import com.fshow.api.generate.core.model.ApiRequestParamModel;
import com.fshow.api.generate.core.model.ApiReturnParamModel;
import com.fshow.api.generate.core.model.FieldSupportModel;
import com.fshow.api.generate.core.model.ParamModel;
import com.fshow.api.generate.core.util.biz.ReadClassNoteUtil;
import com.fshow.api.generate.core.util.biz.ReadMethodNoteUtil;
import com.fshow.api.generate.core.util.tool.ApiJsonFormatUtil;
import com.fshow.api.generate.core.util.tool.ApiStrReplaceUtil;
import com.fshow.api.generate.core.util.tool.MatcherUtil;
import com.fshow.api.generate.core.util.tool.TypeMatchUtil;
import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;

public class ApiSupportUtil {
    private static final int ZERO = 0;
    private static final int ONE = 1;

    public static ApiOutModel geApiOutModel(Document document, Map<String, String> srcMappingMap, String classPackageName) throws Exception {
        Class<?> clazz = Class.forName(classPackageName);
        Method[] methods = clazz.getDeclaredMethods();
        if (null == methods || methods.length == 0) {
            System.out.println(MessageFormat.format(">>> \u5f53\u524d\u63a5\u53e3\u7c7b\uff1a{0} -> \u65b9\u6cd5\u4e0d\u5b58\u5728,\u6267\u884c\u7ed3\u675f", classPackageName));
            return null;
        }
        ApiOutModel apiOutModel = new ApiOutModel();
        Map<String, ApiDescModel> beanMethodMap = ReadMethodNoteUtil.readMethodNoteMap(srcMappingMap, classPackageName);
        String rootPath = ApiSupportUtil.getControllerRootPath(clazz);
        ApiOutBaseModel apiOutBaseModel = null;
        ArrayList<ApiOutBaseModel> apiBaseList = new ArrayList<ApiOutBaseModel>();
        for (Method method : methods) {
            if (2 == method.getModifiers()) {
                System.out.println(MessageFormat.format(">>> \u5f53\u524d\u63a5\u53e3\u7c7b\uff1a{0} => \u65b9\u6cd5:{1} \u79c1\u6709\u65b9\u6cd5\uff0c\u81ea\u52a8\u8fc7\u6ee4", classPackageName, method.getName()));
                continue;
            }
            String methodName = MatcherUtil.replaceBrackets(method.getName());
            ApiRequestParamModel requestParamModel = ApiSupportUtil.getMethodParamMap(document, srcMappingMap, method);
            ApiReturnParamModel returnParamModel = ApiSupportUtil.getMethodReturnMap(document, srcMappingMap, method);
            String[] pathAndType = ApiSupportUtil.getMethodPathAndType(method);
            apiOutBaseModel = new ApiOutBaseModel();
            if (beanMethodMap.containsKey(methodName)) {
                ApiDescModel apiDescModel = beanMethodMap.get(methodName);
                apiOutBaseModel.setApiDesc(apiDescModel.getDescription());
                apiOutBaseModel.setApiAuthor(apiDescModel.getAuthor());
            }
            ApiSupportUtil.doOpenApiMethod(document, apiOutBaseModel, method);
            apiOutBaseModel.setPath(rootPath.concat(pathAndType[1]));
            apiOutBaseModel.setRequestType(pathAndType[0]);
            apiOutBaseModel.setRequestParamModel(requestParamModel);
            apiOutBaseModel.setReturnParamModel(returnParamModel);
            apiBaseList.add(apiOutBaseModel);
        }
        if (beanMethodMap.containsKey("controller_name_key.")) {
            apiOutModel.setApiParentDesc(beanMethodMap.get("controller_name_key.").getDescription());
        }
        apiOutModel.setApiBaseList(apiBaseList);
        return apiOutModel;
    }

    private static void doOpenApiMethod(Document document, ApiOutBaseModel apiOutBaseModel, Method method) {
        OpenApiConfigModel configModel = ConfigXmlReadUtil.getOpenApiAnnotationClass(document);
        if (null == configModel) {
            return;
        }
        Class<?> aClass = configModel.getAClass();
        if (null == aClass) {
            return;
        }
        try {
            Object annotation = method.getAnnotation(aClass);
            String jsonString = JSON.toJSONString(annotation);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            Object methodPath = jsonObject.get((Object)configModel.getPathFieldName());
            apiOutBaseModel.setOpenApiMethodPath(String.valueOf(methodPath));
        }
        catch (Exception e) {
            System.out.println(MessageFormat.format(">>> \u5f53\u524d\u65b9\u6cd5 : {0} \u83b7\u53d6\u81ea\u5b9a\u4e49\u5f00\u653e\u63a5\u53e3\u6ce8\u89e3\u4fe1\u606f\u5931\u8d25 !", method.getName()));
        }
    }

    public static ApiRequestParamModel getMethodParamMap(Document document, Map<String, String> srcMappingMap, Method method) {
        Parameter[] parameters = method.getParameters();
        if (null == parameters || parameters.length == 0) {
            System.out.println(MessageFormat.format(">>> \u5f53\u524d\u65b9\u6cd5\uff1a{0} => \u65b9\u6cd5\u53c2\u6570\u4e0d\u5b58\u5728 , \u6267\u884c\u7ed3\u675f", method.getName()));
            return new ApiRequestParamModel();
        }
        ArrayList<ParamModel> paramList = new ArrayList<ParamModel>(0);
        ArrayList<String> jsonDemoList = new ArrayList<String>(0);
        Set<String> paramExcludeSet = ConfigXmlReadUtil.getApiExcludeParams(document);
        for (Parameter parameter : parameters) {
            String paramClassName = parameter.getParameterizedType().getTypeName();
            if (paramExcludeSet.contains(paramClassName)) {
                System.out.println(MessageFormat.format(">>> \u5f53\u524d\u65b9\u6cd5 : {0} , \u53c2\u6570 : {1} , \u5df2\u7ecf\u81ea\u52a8\u8fc7\u6ee4", method.getName(), paramClassName));
                continue;
            }
            if (TypeMatchUtil.isJavaClass(paramClassName)) {
                ParamModel model = ApiSupportUtil.buildParamModel(parameter);
                paramList.add(model);
                continue;
            }
            FieldSupportModel classFieldModel = ApiSupportUtil.getClassFieldModel(srcMappingMap, paramClassName);
            paramList.addAll(classFieldModel.getParamList());
            Integer paramType = ConfigXmlReadUtil.getParamNameType(document);
            if (ApiParamTypeEnum.SNAKE_CASE.getType().equals(String.valueOf(paramType))) {
                jsonDemoList.add(ApiSupportUtil.getSnakeCaseJson(classFieldModel.getJsonObject()));
                continue;
            }
            jsonDemoList.add(ApiJsonFormatUtil.toFormatJson(classFieldModel.getJsonObject()));
        }
        return new ApiRequestParamModel(paramList, jsonDemoList);
    }

    public static ApiReturnParamModel getMethodReturnMap(Document document, Map<String, String> srcMappingMap, Method method) {
        String[] methodReturnArray;
        String typeName = method.getReturnType().getTypeName();
        if ("void".equals(typeName)) {
            return null;
        }
        Set<String> baseTypeSet = SetConstant.BASE_TYPE_SET;
        if (baseTypeSet.contains(typeName)) {
            return null;
        }
        if (TypeMatchUtil.isJavaClass(typeName) && !TypeMatchUtil.isObjectTClass(method.getGenericReturnType().getTypeName())) {
            return null;
        }
        boolean isArray = TypeMatchUtil.isList(typeName) || TypeMatchUtil.isSet(typeName);
        ArrayList<String> returnClazzList = new ArrayList<String>();
        if (!TypeMatchUtil.isJavaClass(typeName)) {
            returnClazzList.add(typeName);
        }
        if ((methodReturnArray = MatcherUtil.getTArrayByMethod(method)).length > 0) {
            returnClazzList.addAll(Arrays.asList(methodReturnArray));
        }
        if (CollectionUtils.isEmpty(returnClazzList)) {
            return null;
        }
        FieldSupportModel resultSupport = null;
        for (int i = returnClazzList.size() - 1; i >= 0; --i) {
            FieldSupportModel currentClassFieldModel = ApiSupportUtil.getClassFieldModel(srcMappingMap, (String)returnClazzList.get(i));
            if (null != resultSupport) {
                JSONObject parentJsonObject = currentClassFieldModel.getJsonObject();
                List<ParamModel> parentParamModelList = currentClassFieldModel.getParamList();
                for (ParamModel paramModel : parentParamModelList) {
                    if (TypeMatchUtil.isObject(paramModel.getType())) {
                        parentJsonObject.put(paramModel.getName(), (Object)resultSupport.getJsonObject());
                        paramModel.setChildren(resultSupport.getParamList());
                        break;
                    }
                    if (!TypeMatchUtil.isTClass(paramModel.getType())) continue;
                    ArrayList<JSONObject> objectList = new ArrayList<JSONObject>();
                    objectList.add(resultSupport.getJsonObject());
                    parentJsonObject.put(paramModel.getName(), objectList);
                    paramModel.setChildren(resultSupport.getParamList());
                }
            }
            resultSupport = currentClassFieldModel;
        }
        if (null != resultSupport) {
            ApiReturnParamModel apiReturnParamModel = new ApiReturnParamModel();
            apiReturnParamModel.setParamList(resultSupport.getParamList());
            Integer paramType = ConfigXmlReadUtil.getParamNameType(document);
            Object resultParam = resultSupport.getJsonObject();
            if (isArray) {
                ArrayList<JSONObject> resultList = new ArrayList<JSONObject>();
                resultList.add(resultSupport.getJsonObject());
                resultParam = resultList;
            }
            if (ApiParamTypeEnum.SNAKE_CASE.getType().equals(String.valueOf(paramType))) {
                apiReturnParamModel.setJsonDemoStr(ApiSupportUtil.getSnakeCaseJson(resultParam));
            } else {
                apiReturnParamModel.setJsonDemoStr(ApiJsonFormatUtil.toFormatJson(resultParam));
            }
            return apiReturnParamModel;
        }
        return null;
    }

    private static String getSnakeCaseJson(Object object) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, ApiJsonFormatUtil.toFormatJson(object));
    }

    public static FieldSupportModel getClassFieldModel(Map<String, String> srcMappingMap, String classPackageName) {
        return ApiSupportUtil.buildClassFieldMap(srcMappingMap, classPackageName, null, null, null);
    }

    private static FieldSupportModel buildClassFieldMap(Map<String, String> srcMappingMap, String classPackageName, ParamModel parentModel, JSONObject parentJson, Field parentField) {
        FieldSupportModel fieldModel = new FieldSupportModel();
        if (StringUtils.isBlank((CharSequence)classPackageName)) {
            return fieldModel;
        }
        try {
            Class<?> paramClazz = Class.forName(classPackageName);
            Field[] paramClazzFields = ApiSupportUtil.getAllFields(paramClazz);
            if (null == paramClazzFields || paramClazzFields.length == 0) {
                return fieldModel;
            }
            ParamModel currentModel = null;
            ArrayList<ParamModel> currentParamModelList = new ArrayList<ParamModel>();
            JSONObject currentJsonObject = JSON.parseObject((String)ApiJsonFormatUtil.toFormatJson(paramClazz.newInstance()));
            Map<String, String> fieldDescMap = ReadClassNoteUtil.readClassNoteMap(srcMappingMap, classPackageName);
            Set<String> fieldExcludeSet = SetConstant.FIELD_EXCLUDE_SET;
            for (Field field : paramClazzFields) {
                if (fieldExcludeSet.contains(field.getName())) continue;
                String simpleType = field.getType().getSimpleName();
                String genericType = field.getGenericType().getTypeName();
                currentModel = ApiSupportUtil.buildParamModel(field, simpleType, fieldDescMap);
                ApiSupportUtil.doProcessClassField(srcMappingMap, classPackageName, genericType, currentModel, currentJsonObject, field);
                currentParamModelList.add(currentModel);
            }
            if (null != parentModel) {
                parentModel.setChildren(currentParamModelList);
            }
            if (null != parentJson && null != parentField) {
                if (parentField.getType().getSimpleName().equals("List")) {
                    ArrayList<JSONObject> list = new ArrayList<JSONObject>();
                    list.add(currentJsonObject);
                    parentJson.put(parentField.getName(), list);
                } else {
                    parentJson.put(parentField.getName(), (Object)currentJsonObject);
                }
            }
            fieldModel.setJsonObject(currentJsonObject);
            fieldModel.setParamList(currentParamModelList);
        }
        catch (Exception e) {
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            if (e instanceof InstantiationException) {
                throw new ApiGenerateException(">>> \u5f53\u524d\u7c7b :{0} \u5c5e\u6027\u5f02\u5e38\u4e86 : \u7f3a\u5c11\u516c\u5171\u7684\u65e0\u53c2\u6784\u9020\u65b9\u6cd5\uff01stack={1}", classPackageName, stackTrace);
            }
            throw new ApiGenerateException(">>> \u5f53\u524d\u7c7b :{0} \u5c5e\u6027\u5f02\u5e38\u4e86 : {1} ,stack={2}", classPackageName, e.getMessage(), stackTrace);
        }
        return fieldModel;
    }

    private static void doProcessClassField(Map<String, String> srcMappingMap, String classPackageName, String genericType, ParamModel currentModel, JSONObject currentJsonObject, Field field) {
        if (TypeMatchUtil.isArray(genericType) && !TypeMatchUtil.isJavaClass(genericType)) {
            String currentPackagePath = ApiStrReplaceUtil.replaceInBracket(genericType);
            ApiSupportUtil.buildClassFieldMap(srcMappingMap, currentPackagePath, currentModel, currentJsonObject, field);
        } else if (TypeMatchUtil.isTClass(genericType)) {
            currentModel.setType(currentModel.getType().concat("<T>"));
        } else if (TypeMatchUtil.isObjectTClass(genericType) && TypeMatchUtil.isJavaClass(genericType)) {
            String[] tArrayField;
            for (String tArrayStr : tArrayField = MatcherUtil.getTArrayByField(field)) {
                if (!classPackageName.equals(tArrayStr) && !TypeMatchUtil.isJavaClass(tArrayStr)) {
                    ApiSupportUtil.buildClassFieldMap(srcMappingMap, tArrayStr, currentModel, currentJsonObject, field);
                    continue;
                }
                if (!TypeMatchUtil.isJavaClass(tArrayStr)) continue;
                String typeFieldByPackage = MatcherUtil.getTypeFieldByPackage(tArrayStr);
                currentModel.setType(currentModel.getType().concat("(").concat(typeFieldByPackage).concat(")"));
            }
        } else if (!TypeMatchUtil.isJavaClass(genericType) && TypeMatchUtil.isSelfClass(genericType)) {
            ApiSupportUtil.buildClassFieldMap(srcMappingMap, genericType, currentModel, currentJsonObject, field);
        }
    }

    private static ParamModel buildParamModel(Parameter parameter) {
        String paramName = "-";
        int requiredFlag = 0;
        RequestParam requestParam = parameter.getAnnotation(RequestParam.class);
        if (null != requestParam && StringUtils.isNotBlank((CharSequence)requestParam.value())) {
            paramName = requestParam.value();
            if (requestParam.required()) {
                requiredFlag = 1;
            }
        } else {
            PathVariable pathVariable = parameter.getAnnotation(PathVariable.class);
            if (null != pathVariable && StringUtils.isNotBlank((CharSequence)pathVariable.value())) {
                paramName = pathVariable.value();
                if (pathVariable.required()) {
                    requiredFlag = 1;
                }
            }
        }
        ParamModel paramModel = new ParamModel();
        paramModel.setName(paramName);
        paramModel.setType(parameter.getType().getSimpleName());
        paramModel.setRequiredFlag(requiredFlag);
        return paramModel;
    }

    public static Boolean checkIsController(Class clazz) {
        if (null == clazz) {
            return false;
        }
        if (clazz.getAnnotation(Controller.class) != null) {
            return true;
        }
        if (clazz.getAnnotation(RestController.class) != null) {
            return true;
        }
        return false;
    }

    public static Boolean isSpringBootTest(Class clazz) {
        try {
            return clazz.getAnnotation(SpringBootTest.class) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String getControllerRootPath(Class clazz) {
        RequestMapping requestMapping = clazz.getAnnotation(RequestMapping.class);
        String rootPath = "";
        if (null != requestMapping && requestMapping.value().length > 0) {
            rootPath = ApiSupportUtil.doProcessRequestPath(requestMapping.value()[0]);
        }
        return rootPath;
    }

    public static String getSrcPath(Map<String, String> srcMappingMap, String classPackageName) {
        String srcPath = null;
        for (Map.Entry<String, String> map : srcMappingMap.entrySet()) {
            if (!classPackageName.contains(map.getKey())) continue;
            srcPath = map.getValue();
            break;
        }
        return srcPath;
    }

    private static String doProcessRequestPath(String requestPath) {
        if (StringUtils.isBlank((CharSequence)requestPath)) {
            return "";
        }
        String path = requestPath.trim();
        if ("/".equals(path)) {
            return "";
        }
        return path;
    }

    private static Field[] getAllFields(Class clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    private static Integer getRequiredFlag(Field field) {
        NotNull notNull = field.getAnnotation(NotNull.class);
        if (null != notNull) {
            return 1;
        }
        NotBlank notBlank = field.getAnnotation(NotBlank.class);
        if (null != notBlank) {
            return 1;
        }
        NotEmpty notEmpty = field.getAnnotation(NotEmpty.class);
        if (null != notEmpty) {
            return 1;
        }
        return 0;
    }

    private static String[] getMethodPathAndType(Method method) {
        String requestType = "POST";
        String requestPath = "";
        RequestMapping methodRequestMapping = method.getAnnotation(RequestMapping.class);
        if (null != methodRequestMapping && methodRequestMapping.value().length > 0) {
            requestPath = methodRequestMapping.value()[0];
            requestType = Arrays.toString(methodRequestMapping.method());
            return new String[]{requestType, requestPath};
        }
        PostMapping postMapping = method.getAnnotation(PostMapping.class);
        if (null != postMapping && postMapping.value().length > 0) {
            requestType = RequestMethod.POST.name();
            requestPath = postMapping.value()[0];
            return new String[]{requestType, requestPath};
        }
        GetMapping getMapping = method.getAnnotation(GetMapping.class);
        if (null != getMapping && getMapping.value().length > 0) {
            requestType = RequestMethod.GET.name();
            requestPath = getMapping.value()[0];
            return new String[]{requestType, requestPath};
        }
        PutMapping putMapping = method.getAnnotation(PutMapping.class);
        if (null != putMapping && putMapping.value().length > 0) {
            requestType = RequestMethod.PUT.name();
            requestPath = putMapping.value()[0];
            return new String[]{requestType, requestPath};
        }
        DeleteMapping deleteMapping = method.getAnnotation(DeleteMapping.class);
        if (null != deleteMapping && deleteMapping.value().length > 0) {
            requestType = RequestMethod.DELETE.name();
            requestPath = deleteMapping.value()[0];
            return new String[]{requestType, requestPath};
        }
        return new String[]{requestType, requestPath};
    }

    private static String getMaxLength(Field field) {
        Min min = field.getAnnotation(Min.class);
        Max max = field.getAnnotation(Max.class);
        StringBuilder sizeStr = new StringBuilder();
        if (null != min && null != max) {
            sizeStr.append(min.value());
            sizeStr.append("-");
            sizeStr.append(max.value());
            return String.valueOf(sizeStr);
        }
        if (null != max) {
            sizeStr.append(max.value());
            return String.valueOf(sizeStr);
        }
        Size size = field.getAnnotation(Size.class);
        if (null != size) {
            sizeStr.append(size.min());
            sizeStr.append("-");
            sizeStr.append(size.max());
            return String.valueOf(sizeStr);
        }
        Length length = field.getAnnotation(Length.class);
        if (null != length) {
            sizeStr.append(length.min());
            sizeStr.append("-");
            sizeStr.append(length.max());
            return String.valueOf(sizeStr);
        }
        return "";
    }

    private static ParamModel buildParamModel(Field field, String simpleType, Map<String, String> fieldDescMap) {
        ParamModel paramModel = new ParamModel();
        paramModel.setName(field.getName());
        paramModel.setType(simpleType);
        paramModel.setDescription(MatcherUtil.stringValueOf(fieldDescMap.get(field.getName())));
        paramModel.setRequiredFlag(ApiSupportUtil.getRequiredFlag(field));
        paramModel.setLength(ApiSupportUtil.getMaxLength(field));
        return paramModel;
    }
}

