/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.core.util.biz;

import com.fshow.api.generate.core.model.ApiOutBaseModel;
import com.fshow.api.generate.core.model.ApiOutModel;
import com.fshow.api.generate.core.model.ApiRequestParamModel;
import com.fshow.api.generate.core.model.ApiReturnParamModel;
import com.fshow.api.generate.core.model.ParamModel;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;

public class ApiParamUtil {
    private static final int ZERO = 0;
    private static final int ONE = 1;

    public static void doProcessApiOutModel(ApiOutModel apiOutModel) {
        List<ApiOutBaseModel> apiBaseList = apiOutModel.getApiBaseList();
        if (CollectionUtils.isEmpty(apiBaseList)) {
            return;
        }
        for (ApiOutBaseModel baseModel : apiBaseList) {
            AtomicInteger reqMaxLevel = new AtomicInteger(0);
            AtomicInteger reqCurrentLevel = new AtomicInteger(1);
            AtomicInteger resMaxLevel = new AtomicInteger(0);
            AtomicInteger resCurrentLevel = new AtomicInteger(1);
            ApiRequestParamModel requestParamModel = baseModel.getRequestParamModel();
            ApiReturnParamModel returnParamModel = baseModel.getReturnParamModel();
            if (null != requestParamModel) {
                ApiParamUtil.doChildParamTotalSize(requestParamModel.getParamList());
                ApiParamUtil.doMaxParamLevel(reqMaxLevel, reqCurrentLevel, requestParamModel.getParamList());
                requestParamModel.setParamTotalLevel(reqMaxLevel.intValue());
            }
            if (null == returnParamModel) continue;
            ApiParamUtil.doChildParamTotalSize(returnParamModel.getParamList());
            ApiParamUtil.doMaxParamLevel(resMaxLevel, resCurrentLevel, returnParamModel.getParamList());
            returnParamModel.setParamTotalLevel(resMaxLevel.intValue());
        }
    }

    private static void doChildParamTotalSize(List<ParamModel> paramModelList) {
        if (CollectionUtils.isEmpty(paramModelList)) {
            return;
        }
        for (ParamModel model : paramModelList) {
            AtomicInteger childSizeParam = new AtomicInteger(0);
            childSizeParam.incrementAndGet();
            if (!CollectionUtils.isNotEmpty(model.getChildren())) continue;
            ApiParamUtil.doChildParamSize(childSizeParam, model.getChildren());
            model.setChildParamSize(childSizeParam.intValue() - 1);
            ApiParamUtil.doChildParamTotalSize(model.getChildren());
        }
    }

    private static void doChildParamSize(AtomicInteger childSizeParam, List<ParamModel> paramModelList) {
        if (CollectionUtils.isEmpty(paramModelList)) {
            return;
        }
        for (ParamModel model : paramModelList) {
            childSizeParam.incrementAndGet();
            if (!CollectionUtils.isNotEmpty(model.getChildren())) continue;
            ApiParamUtil.doChildParamSize(childSizeParam, model.getChildren());
        }
    }

    private static void doMaxParamLevel(AtomicInteger maxLevel, AtomicInteger currentLevel, List<ParamModel> paramModelList) {
        int i = currentLevel.intValue();
        if (currentLevel.intValue() > maxLevel.intValue()) {
            maxLevel.set(currentLevel.intValue());
        }
        if (CollectionUtils.isEmpty(paramModelList)) {
            return;
        }
        for (ParamModel model : paramModelList) {
            if (CollectionUtils.isNotEmpty(model.getChildren())) {
                currentLevel.incrementAndGet();
                ApiParamUtil.doMaxParamLevel(maxLevel, currentLevel, model.getChildren());
            }
            currentLevel.set(i);
        }
    }
}

