/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.api.generate.core.config;

import com.fshow.api.generate.core.config.model.OpenApiConfigModel;
import com.fshow.api.generate.core.constant.SetConstant;
import com.fshow.api.generate.core.enums.ApiParamTypeEnum;
import com.fshow.api.generate.core.exception.ApiGenerateException;
import freemarker.log.Logger;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigXmlReadUtil {
    public static Document getDocument(String configXmlPath) {
        Document document = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            document = db.parse(new File(configXmlPath));
            Logger.selectLoggerLibrary((int)0);
        }
        catch (Exception e) {
            throw new ApiGenerateException("\u5730\u5740: {0} \u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01", configXmlPath);
        }
        return document;
    }

    public static Map<String, String> getSrcMappingMap(Document document) {
        HashMap<String, String> propertyMap = new HashMap<String, String>(64);
        NodeList propertyList = document.getElementsByTagName("srcPathMapping");
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Node table = propertyList.item(i);
            NamedNodeMap attrs = table.getAttributes();
            String nameKey = attrs.getNamedItem("key").getNodeValue();
            if (StringUtils.isBlank((CharSequence)nameKey)) {
                throw new ApiGenerateException("\u6620\u5c04\u5305\u5730\u5740 srcPathMapping > key \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String valueKey = attrs.getNamedItem("value").getNodeValue();
            if (StringUtils.isBlank((CharSequence)valueKey)) {
                throw new ApiGenerateException("\u6620\u5c04\u5305\u5730\u5740 srcPathMapping > value \u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            propertyMap.put(nameKey, valueKey);
        }
        if (MapUtils.isEmpty(propertyMap)) {
            throw new ApiGenerateException("\u6620\u5c04\u5305\u5730\u5740 srcPathMapping \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        propertyMap.entrySet().stream().sorted((o1, o2) -> ((String)o2.getKey()).length() - ((String)o1.getKey()).length()).forEachOrdered(x -> {
            String cfr_ignored_0 = (String)result.put((String)x.getKey(), (String)x.getValue());
        });
        return result;
    }

    public static Set<Class<?>> getApiClassPackages(Document document) {
        NodeList propertyList = document.getElementsByTagName("apiClassPackages");
        String value = ConfigXmlReadUtil.getValue(propertyList);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new ApiGenerateException("\u751f\u6210\u7c7b\u5730\u5740 apiClassPackages > value \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] splitPackage = value.split(",");
        HashSet clazzSet = new HashSet(splitPackage.length);
        if (splitPackage.length > 0) {
            for (String str : splitPackage) {
                try {
                    Class<?> aClass = Class.forName(str);
                    clazzSet.add(aClass);
                }
                catch (Exception e) {
                    throw new ApiGenerateException("\u7c7b\u5730\u5740: {0} \u4e0d\u5b58\u5728", str);
                }
            }
        }
        return clazzSet;
    }

    public static Set<String> getApiExcludeParams(Document document) {
        NodeList propertyList = document.getElementsByTagName("apiExcludeParams");
        String value = ConfigXmlReadUtil.getValue(propertyList);
        if (StringUtils.isBlank((CharSequence)value)) {
            return SetConstant.PARAM_EXCLUDE_SET;
        }
        HashSet<String> paramExcludeSet = new HashSet<String>();
        paramExcludeSet.addAll(SetConstant.PARAM_EXCLUDE_SET);
        String[] splitStr = value.split(",");
        if (splitStr.length > 0) {
            paramExcludeSet.addAll(Arrays.asList(splitStr));
        }
        return paramExcludeSet;
    }

    public static String getApiPackage(Document document) {
        NodeList propertyList = document.getElementsByTagName("apiPackage");
        String value = ConfigXmlReadUtil.getValue(propertyList);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new ApiGenerateException("\u751f\u6210\u5305\u5730\u5740 apiPackage > value \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return value;
    }

    public static Integer getJsonFlag(Document document) {
        NodeList propertyList = document.getElementsByTagName("generateJsonDemo");
        if (null == propertyList || propertyList.getLength() == 0) {
            return 1;
        }
        String value = ConfigXmlReadUtil.getValue(propertyList);
        if (StringUtils.isNotBlank((CharSequence)value) && "2".equals(value)) {
            return 2;
        }
        return 1;
    }

    public static Boolean getShowLogFlag(Document document) {
        NodeList propertyList = document.getElementsByTagName("log");
        String value = ConfigXmlReadUtil.getValue(propertyList);
        return StringUtils.isNotBlank((CharSequence)value) && "1".equals(value);
    }

    public static String getGenerateType(Document document) {
        NodeList propertyList = document.getElementsByTagName("generateType");
        return ConfigXmlReadUtil.getValue(propertyList);
    }

    public static Integer getParamNameType(Document document) {
        NodeList propertyList = document.getElementsByTagName("apiParamNameType");
        String value = ConfigXmlReadUtil.getValue(propertyList);
        if (StringUtils.isBlank((CharSequence)value)) {
            return 1;
        }
        ApiParamTypeEnum paramType = ApiParamTypeEnum.getParamType(value);
        if (null == paramType) {
            throw new ApiGenerateException(">>> \u53c2\u6570\u7c7b\u578b apiParamType > value \u5f53\u524d\u503c\u4e0d\u5b58\u5728,\u53d6\u503c\u8303\u56f4\u53ea\u80fd\u4e3a {0} \uff01", ApiParamTypeEnum.getAllType());
        }
        return Integer.parseInt(paramType.getType());
    }

    public static OpenApiConfigModel getOpenApiAnnotationClass(Document document) {
        NodeList propertyList = document.getElementsByTagName("openApiAnnoPackage");
        String value = null;
        String pathFileName = "method";
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Node table = propertyList.item(i);
            NamedNodeMap attrs = table.getAttributes();
            if (null != attrs.getNamedItem("pathFieldName")) {
                pathFileName = attrs.getNamedItem("pathFieldName").getNodeValue();
            }
            if (null == attrs.getNamedItem("value")) continue;
            value = attrs.getNamedItem("value").getNodeValue();
        }
        if (StringUtils.isBlank(value)) {
            return null;
        }
        OpenApiConfigModel configModel = new OpenApiConfigModel();
        Class<?> aClass = null;
        try {
            aClass = Class.forName(value);
            configModel.setAClass(aClass);
            configModel.setPathFieldName(pathFileName);
        }
        catch (Exception e) {
            throw new ApiGenerateException("\u5f00\u653e\u63a5\u53e3\u6ce8\u89e3\u7c7b\u5730\u5740: openApiAnnoPackage > value {0} \u4e0d\u5b58\u5728", value);
        }
        return configModel;
    }

    public static String getGenerateFilePath(Document document) {
        NodeList propertyList = document.getElementsByTagName("generateFilePath");
        String value = ConfigXmlReadUtil.getValue(propertyList);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new ApiGenerateException("\u751f\u6210\u6587\u4ef6\u5730\u5740 generateFilePath > value \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return value;
    }

    private static String getValue(NodeList propertyList) {
        String value = null;
        try {
            for (int i = 0; i < propertyList.getLength(); ++i) {
                Node table = propertyList.item(i);
                NamedNodeMap attrs = table.getAttributes();
                value = attrs.getNamedItem("value").getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ApiGenerateException("\u914d\u7f6eXML\u6587\u4ef6 > \u914d\u7f6e\u9879 > value \u83b7\u53d6\u5931\u8d25\u4e86 \uff01");
        }
        return value;
    }
}

