/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api.msg;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import shade.com.alipay.api.internal.util.AlipayUtils;
import shade.com.alipay.api.internal.util.StringUtils;
import shade.com.alipay.api.msg.Message;

public class ProtocolData {
    private static final AtomicInteger seq = new AtomicInteger(0);
    private static final String RANDOM_NUM = AlipayUtils.toRadix62Str(new Random().nextInt((int)AlipayUtils.fromRadix62Str("zz")), 2);
    private String fromSys;
    private String fromSysIp;
    private String streamId = ProtocolData.genStreamId();
    private Message message;

    public static ProtocolData fromStr(String str) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        int i = str.indexOf("\r\n\r\n");
        if (i < 0) {
            throw new IllegalArgumentException("not find CRLF2. " + str);
        }
        ProtocolData protocolData = new ProtocolData();
        String protocol = str.substring(0, i);
        String data = str.substring(i + "\r\n\r\n".length());
        try {
            if (!StringUtils.isEmpty(protocol)) {
                String[] kvs;
                for (String kvStr : kvs = protocol.split("\r\n")) {
                    String[] kv = kvStr.split(":");
                    if ("from-sys".equals(kv[0].trim())) {
                        protocolData.setFromSys(kv[1].trim());
                        continue;
                    }
                    if ("from-sys-ip".equals(kv[0].trim())) {
                        protocolData.setFromSysIp(kv[1].trim());
                        continue;
                    }
                    if (!"stream-id".equals(kv[0].trim())) continue;
                    protocolData.setStreamId(kv[1].trim());
                }
            }
            if (!StringUtils.isEmpty(data)) {
                protocolData.setMessage(Message.fromStr(data));
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("format illegal. exception:" + t.getMessage() + " str:" + str);
        }
        return protocolData;
    }

    public static String toStr(ProtocolData protocolData) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty(protocolData.getFromSys())) {
            sb.append("from-sys").append(":").append(protocolData.getFromSys()).append("\r\n");
        }
        if (!StringUtils.isEmpty(protocolData.getFromSysIp())) {
            sb.append("from-sys-ip").append(":").append(protocolData.getFromSysIp()).append("\r\n");
        }
        if (!StringUtils.isEmpty(protocolData.getStreamId())) {
            sb.append("stream-id").append(":").append(protocolData.getStreamId()).append("\r\n");
        }
        if (sb.length() <= 0) {
            sb.append("\r\n");
        }
        sb.append("\r\n");
        if (protocolData.getMessage() != null) {
            sb.append(Message.toStr(protocolData.getMessage()));
        }
        return sb.toString();
    }

    public static String genStreamId() {
        long cur = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        sb.append("c");
        sb.append(AlipayUtils.toRadix62Str(cur, 8));
        sb.append(RANDOM_NUM);
        int curSeq = seq.getAndIncrement();
        if (curSeq >= 200000) {
            seq.set(0);
        }
        sb.append(AlipayUtils.toRadix62Str(curSeq, 3));
        return sb.toString();
    }

    public String getFromSys() {
        return this.fromSys;
    }

    public void setFromSys(String fromSys) {
        this.fromSys = fromSys;
    }

    public String getFromSysIp() {
        return this.fromSysIp;
    }

    public void setFromSysIp(String fromSysIp) {
        this.fromSysIp = fromSysIp;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public String toString() {
        return ProtocolData.toStr(this).replaceAll(":", "\\\\r\\\\n");
    }
}

