/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api.kms.aliyun;

import java.util.HashMap;
import java.util.Map;
import shade.com.alipay.api.Signer;
import shade.com.alipay.api.kms.aliyun.AliyunKMSClient;

public class AliyunKMSSigner
implements Signer {
    private final AliyunKMSClient client;
    private String keyId;
    private String keyVersionId;
    private String algorithm;
    private static final Map<String, String> signAlgs = new HashMap<String, String>();

    public AliyunKMSSigner(AliyunKMSClient client, String keyId, String keyVersionId) {
        this.client = client;
        this.keyId = keyId;
        this.keyVersionId = keyVersionId;
        this.algorithm = null;
    }

    @Override
    public String sign(String sourceContent, String signType, String charset) {
        try {
            if (this.algorithm == null || this.algorithm.isEmpty()) {
                if (!signType.equals("RSA")) {
                    this.algorithm = signAlgs.get(signType);
                } else {
                    throw new RuntimeException("KMS not supported signType: " + signType);
                }
            }
            return this.client.sign(this.keyId, this.keyVersionId, this.algorithm, sourceContent.getBytes(charset));
        }
        catch (Exception e) {
            throw new RuntimeException("exception obtaining KMS signature: " + e.getMessage(), e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public void setKeyVersionId(String keyVersionId) {
        this.keyVersionId = keyVersionId;
    }

    static {
        signAlgs.put("RSA2", "RSA_PKCS1_SHA_256");
        signAlgs.put("SM2", "SM2DSA");
    }
}

