/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api.java_websocket;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import shade.com.alipay.api.java_websocket.WebSocket;
import shade.com.alipay.api.java_websocket.WebSocketAdapter;
import shade.com.alipay.api.java_websocket.WebSocketImpl;

public abstract class AbstractWebSocket
extends WebSocketAdapter {
    private boolean tcpNoDelay;
    private boolean reuseAddr;
    private Timer connectionLostTimer;
    private TimerTask connectionLostTimerTask;
    private int connectionLostTimeout = 60;
    private boolean websocketRunning = false;

    public int getConnectionLostTimeout() {
        return this.connectionLostTimeout;
    }

    public void setConnectionLostTimeout(int connectionLostTimeout) {
        this.connectionLostTimeout = connectionLostTimeout;
        if (this.connectionLostTimeout <= 0) {
            this.cancelConnectionLostTimer();
            return;
        }
        if (this.websocketRunning) {
            try {
                ArrayList<WebSocket> connections = new ArrayList<WebSocket>(this.getConnections());
                for (WebSocket conn : connections) {
                    if (!(conn instanceof WebSocketImpl)) continue;
                    WebSocketImpl webSocketImpl = (WebSocketImpl)conn;
                    webSocketImpl.updateLastPong();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.restartConnectionLostTimer();
        }
    }

    protected void stopConnectionLostTimer() {
        if (this.connectionLostTimer != null || this.connectionLostTimerTask != null) {
            this.websocketRunning = false;
            this.cancelConnectionLostTimer();
        }
    }

    protected void startConnectionLostTimer() {
        if (this.connectionLostTimeout <= 0) {
            return;
        }
        this.websocketRunning = true;
        this.restartConnectionLostTimer();
    }

    private void restartConnectionLostTimer() {
        this.cancelConnectionLostTimer();
        this.connectionLostTimer = new Timer("WebSocketTimer");
        this.connectionLostTimerTask = new TimerTask(){
            private ArrayList<WebSocket> connections = new ArrayList();

            @Override
            public void run() {
                this.connections.clear();
                try {
                    this.connections.addAll(AbstractWebSocket.this.getConnections());
                    long current = System.currentTimeMillis() - (long)(AbstractWebSocket.this.connectionLostTimeout * 1500);
                    for (WebSocket conn : this.connections) {
                        if (!(conn instanceof WebSocketImpl)) continue;
                        WebSocketImpl webSocketImpl = (WebSocketImpl)conn;
                        if (webSocketImpl.getLastPong() < current) {
                            webSocketImpl.closeConnection(1006, "The connection was closed because the other endpoint did not respond with a pong in time. For more information check: https://github.com/TooTallNate/Java-WebSocket/wiki/Lost-connection-detection");
                            continue;
                        }
                        if (!webSocketImpl.isOpen()) continue;
                        webSocketImpl.sendPing();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connections.clear();
            }
        };
        this.connectionLostTimer.scheduleAtFixedRate(this.connectionLostTimerTask, 1000L * (long)this.connectionLostTimeout, 1000L * (long)this.connectionLostTimeout);
    }

    protected abstract Collection<WebSocket> getConnections();

    private void cancelConnectionLostTimer() {
        if (this.connectionLostTimer != null) {
            this.connectionLostTimer.cancel();
            this.connectionLostTimer = null;
        }
        if (this.connectionLostTimerTask != null) {
            this.connectionLostTimerTask.cancel();
            this.connectionLostTimerTask = null;
        }
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isReuseAddr() {
        return this.reuseAddr;
    }

    public void setReuseAddr(boolean reuseAddr) {
        this.reuseAddr = reuseAddr;
    }
}

