/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api.internal.util.encrypt.impl;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import shade.com.alipay.api.AlipayApiErrorEnum;
import shade.com.alipay.api.AlipayApiException;
import shade.com.alipay.api.internal.util.codec.Base64;
import shade.com.alipay.api.internal.util.encrypt.Encrypt;

public class AesEncrypt
implements Encrypt {
    private static final String AES_ALG = "AES";
    private static final String AES_CBC_PCK_ALG = "AES/CBC/PKCS5Padding";
    private static final byte[] AES_IV = AesEncrypt.initIv("AES/CBC/PKCS5Padding");

    @Override
    public String encrypt(String content, String key, String charset) throws AlipayApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AES_IV);
            cipher.init(1, (Key)new SecretKeySpec(Base64.decodeBase64(key.getBytes()), AES_ALG), iv);
            byte[] encryptBytes = cipher.doFinal(content.getBytes(charset));
            return new String(Base64.encodeBase64(encryptBytes));
        }
        catch (UnsupportedEncodingException e) {
            throw new AlipayApiException(String.format(AlipayApiErrorEnum.ENCRYPT_ASE_CHARSET_ERROR.getErrMsg(), charset), (Throwable)e);
        }
        catch (Exception e) {
            throw new AlipayApiException(String.format(AlipayApiErrorEnum.ENCRYPT_ASE_ERROR.getErrMsg(), content, charset), (Throwable)e);
        }
    }

    @Override
    public String decrypt(String content, String key, String charset) throws AlipayApiException {
        try {
            Cipher cipher = Cipher.getInstance(AES_CBC_PCK_ALG);
            IvParameterSpec iv = new IvParameterSpec(AesEncrypt.initIv(AES_CBC_PCK_ALG));
            cipher.init(2, (Key)new SecretKeySpec(Base64.decodeBase64(key.getBytes()), AES_ALG), iv);
            byte[] cleanBytes = cipher.doFinal(Base64.decodeBase64(content.getBytes()));
            return new String(cleanBytes, charset);
        }
        catch (Exception e) {
            throw new AlipayApiException(String.format(AlipayApiErrorEnum.DECRYPT_ASE_ERROR.getErrMsg(), content, charset), (Throwable)e);
        }
    }

    private static byte[] initIv(String fullAlg) {
        try {
            Cipher cipher = Cipher.getInstance(fullAlg);
            int blockSize = cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
        catch (Exception e) {
            int blockSize = 16;
            byte[] iv = new byte[blockSize];
            for (int i = 0; i < blockSize; ++i) {
                iv[i] = 0;
            }
            return iv;
        }
    }
}

