/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api.internal.util.asymmetric;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import shade.com.alipay.api.AlipayApiErrorEnum;
import shade.com.alipay.api.AlipayApiException;
import shade.com.alipay.api.internal.util.StringUtils;
import shade.com.alipay.api.internal.util.asymmetric.IAsymmetricEncryptor;
import shade.com.alipay.api.internal.util.asymmetric.RSA2Encryptor;
import shade.com.alipay.api.internal.util.asymmetric.RSAEncryptor;
import shade.com.alipay.api.internal.util.asymmetric.SM2Encryptor;

public class AsymmetricManager {
    private static final Map<String, IAsymmetricEncryptor> asymmetricManager = new ConcurrentHashMap<String, IAsymmetricEncryptor>();

    public static IAsymmetricEncryptor getByName(String type) throws AlipayApiException {
        IAsymmetricEncryptor asymmetricEncryptor = null;
        if (!StringUtils.isEmpty(type)) {
            asymmetricEncryptor = asymmetricManager.get(type);
        }
        if (asymmetricEncryptor != null) {
            return asymmetricEncryptor;
        }
        if ("SM2".equals(type)) {
            return new SM2Encryptor();
        }
        throw new AlipayApiException(String.format(AlipayApiErrorEnum.SIGN_TYPE_ERROR.getErrMsg(), type));
    }

    public static Map<String, IAsymmetricEncryptor> getAsymmetricManager() {
        return asymmetricManager;
    }

    public static void putAsymmetricManager(String signType, IAsymmetricEncryptor asymmetricEncryptor) {
        asymmetricManager.put(signType, asymmetricEncryptor);
    }

    static {
        asymmetricManager.put("RSA", new RSAEncryptor());
        asymmetricManager.put("RSA2", new RSA2Encryptor());
    }
}

