/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api.internal.util;

import java.io.IOException;
import shade.com.alipay.api.AlipayApiException;
import shade.com.alipay.api.FileItem;

public class RequestCheckUtils {
    public static final String ERROR_CODE_ARGUMENTS_MISS = "40001";
    public static final String ERROR_CODE_ARGUMENTS_INVALID = "40002";

    public static void checkNotEmpty(Object value, String fieldName) throws AlipayApiException {
        if (value == null) {
            throw new AlipayApiException(ERROR_CODE_ARGUMENTS_MISS, "client-error:Missing Required Arguments:" + fieldName + "");
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            throw new AlipayApiException(ERROR_CODE_ARGUMENTS_MISS, "client-error:Missing Required Arguments:" + fieldName + "");
        }
    }

    public static void checkMaxLength(String value, int maxLength, String fieldName) throws AlipayApiException {
        if (value != null && value.length() > maxLength) {
            throw new AlipayApiException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the length of " + fieldName + " can not be larger than " + maxLength + ".");
        }
    }

    public static void checkMaxLength(FileItem fileItem, int maxLength, String fieldName) throws AlipayApiException {
        try {
            if (fileItem != null && fileItem.getContent() != null && fileItem.getContent().length > maxLength) {
                throw new AlipayApiException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the length of " + fieldName + " can not be larger than " + maxLength + ".");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void checkMaxListSize(String value, int maxSize, String fieldName) throws AlipayApiException {
        String[] list;
        if (value != null && (list = value.split(",")) != null && list.length > maxSize) {
            throw new AlipayApiException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the listsize(the string split by \",\") of " + fieldName + " must be less than " + maxSize + ".");
        }
    }

    public static void checkMaxValue(Long value, long maxValue, String fieldName) throws AlipayApiException {
        if (value != null && value > maxValue) {
            throw new AlipayApiException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the value of " + fieldName + " can not be larger than " + maxValue + ".");
        }
    }

    public static void checkMinValue(Long value, long minValue, String fieldName) throws AlipayApiException {
        if (value != null && value < minValue) {
            throw new AlipayApiException(ERROR_CODE_ARGUMENTS_INVALID, "client-error:Invalid Arguments:the value of " + fieldName + " can not be less than " + minValue + ".");
        }
    }
}

