/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api.internal.util;

import java.util.HashMap;
import java.util.Map;
import shade.com.alipay.api.AlipayApiErrorEnum;
import shade.com.alipay.api.AlipayApiException;
import shade.com.alipay.api.internal.util.encrypt.Encrypt;
import shade.com.alipay.api.internal.util.encrypt.impl.AesEncrypt;
import shade.com.alipay.api.internal.util.encrypt.impl.AesEncryptV2;
import shade.com.alipay.api.internal.util.encrypt.impl.SM4Encrypt;

public class AlipayEncrypt {
    private static Map<String, Encrypt> encryptManager = new HashMap<String, Encrypt>();

    public static String encryptContent(String content, String encryptType, String encryptKey, String charset) throws AlipayApiException {
        Encrypt encrypt = encryptManager.get(encryptType);
        if (encrypt == null) {
            if ("SM4".equals(encryptType)) {
                encrypt = new SM4Encrypt();
            } else {
                throw new AlipayApiException(AlipayApiErrorEnum.ENCRYPT_TYPE_ERROR.getErrMsg() + encryptType);
            }
        }
        return encrypt.encrypt(content, encryptKey, charset);
    }

    public static String decryptContent(String content, String encryptType, String encryptKey, String charset) throws AlipayApiException {
        Encrypt encrypt = encryptManager.get(encryptType);
        if (encrypt == null) {
            if ("SM4".equals(encryptType)) {
                encrypt = new SM4Encrypt();
            } else {
                throw new AlipayApiException(AlipayApiErrorEnum.ENCRYPT_TYPE_ERROR.getErrMsg() + encryptType);
            }
        }
        return encrypt.decrypt(content, encryptKey, charset);
    }

    public static Map<String, Encrypt> getEncryptManager() {
        return encryptManager;
    }

    public static void putEncryptManager(String encryptType, Encrypt encrypt) {
        encryptManager.put(encryptType, encrypt);
    }

    static {
        encryptManager.put("AES", new AesEncrypt());
        encryptManager.put("AES_V2", new AesEncryptV2());
    }
}

