/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api.internal.mapping;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import shade.com.alipay.api.AlipayApiException;
import shade.com.alipay.api.AlipayResponse;
import shade.com.alipay.api.internal.mapping.AlipayFieldMethod;
import shade.com.alipay.api.internal.mapping.ApiField;
import shade.com.alipay.api.internal.mapping.ApiListField;
import shade.com.alipay.api.internal.mapping.Reader;
import shade.com.alipay.api.internal.util.StringUtils;

public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Set<String> baseFields = new HashSet<String>();
    private static final Set<String> excludeFields = new HashSet<String>();
    private static final Set<String> overideFields = new HashSet<String>();

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader) throws AlipayApiException {
        T rsp = null;
        try {
            rsp = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
            boolean isResponseClazz = AlipayResponse.class.isAssignableFrom(clazz);
            for (PropertyDescriptor pd : pds) {
                AlipayFieldMethod alipayFieldMethod2;
                Field field;
                Method writeMethod = pd.getWriteMethod();
                if (writeMethod == null) continue;
                String itemName = pd.getName();
                String listName = null;
                if (isResponseClazz && excludeFields.contains(itemName)) continue;
                ArrayList<AlipayFieldMethod> alipayFieldMethods = new ArrayList<AlipayFieldMethod>();
                if (baseFields.contains(itemName) && isResponseClazz) {
                    field = AlipayResponse.class.getDeclaredField(itemName);
                    alipayFieldMethod2 = new AlipayFieldMethod();
                    alipayFieldMethod2.setField(field);
                    if (writeMethod.getDeclaringClass().getName().contains("AlipayResponse")) {
                        alipayFieldMethod2.setMethod(writeMethod);
                    } else {
                        if ((writeMethod = Converters.tryGetSetMethod(AlipayResponse.class, field, writeMethod.getName())) == null) continue;
                        alipayFieldMethod2.setMethod(writeMethod);
                    }
                    alipayFieldMethods.add(alipayFieldMethod2);
                    if (overideFields.contains(itemName) && (field = Converters.tryGetFieldWithoutExp(clazz, itemName)) != null) {
                        if ((writeMethod = Converters.tryGetSetMethod(clazz, field, writeMethod.getName())) == null) continue;
                        alipayFieldMethod2 = new AlipayFieldMethod();
                        alipayFieldMethod2.setField(field);
                        alipayFieldMethod2.setMethod(writeMethod);
                        alipayFieldMethods.add(alipayFieldMethod2);
                    }
                } else {
                    field = clazz.getDeclaredField(itemName);
                    alipayFieldMethod2 = new AlipayFieldMethod();
                    alipayFieldMethod2.setField(field);
                    alipayFieldMethod2.setMethod(writeMethod);
                    alipayFieldMethods.add(alipayFieldMethod2);
                }
                for (AlipayFieldMethod alipayFieldMethod2 : alipayFieldMethods) {
                    Object value;
                    ApiListField jsonListField;
                    Field field2 = alipayFieldMethod2.getField();
                    Method method = alipayFieldMethod2.getMethod();
                    ApiField jsonField = field2.getAnnotation(ApiField.class);
                    if (jsonField != null) {
                        itemName = jsonField.value();
                    }
                    if ((jsonListField = field2.getAnnotation(ApiListField.class)) != null) {
                        listName = jsonListField.value();
                    }
                    if (!reader.hasReturnField(itemName) && (listName == null || !reader.hasReturnField(listName))) continue;
                    Class<?> typeClass = field2.getType();
                    if (String.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof String) {
                            method.invoke(rsp, value.toString());
                            continue;
                        }
                        if (isCheckJsonType && value != null) {
                            throw new AlipayApiException(itemName + " is not a String");
                        }
                        if (value != null) {
                            method.invoke(rsp, value.toString());
                            continue;
                        }
                        method.invoke(rsp, "");
                        continue;
                    }
                    if (Long.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Long) {
                            method.invoke(rsp, (Long)value);
                            continue;
                        }
                        if (isCheckJsonType && value != null) {
                            throw new AlipayApiException(itemName + " is not a Number(Long)");
                        }
                        if (!StringUtils.isNumeric(value)) continue;
                        method.invoke(rsp, Long.valueOf(value.toString()));
                        continue;
                    }
                    if (Integer.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Integer) {
                            method.invoke(rsp, (Integer)value);
                            continue;
                        }
                        if (isCheckJsonType && value != null) {
                            throw new AlipayApiException(itemName + " is not a Number(Integer)");
                        }
                        if (!StringUtils.isNumeric(value)) continue;
                        method.invoke(rsp, Integer.valueOf(value.toString()));
                        continue;
                    }
                    if (Boolean.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Boolean) {
                            method.invoke(rsp, (Boolean)value);
                            continue;
                        }
                        if (isCheckJsonType && value != null) {
                            throw new AlipayApiException(itemName + " is not a Boolean");
                        }
                        if (value == null) continue;
                        method.invoke(rsp, Boolean.valueOf(value.toString()));
                        continue;
                    }
                    if (Double.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Double) {
                            method.invoke(rsp, (Double)value);
                            continue;
                        }
                        if (!isCheckJsonType || value == null) continue;
                        throw new AlipayApiException(itemName + " is not a Double");
                    }
                    if (Number.class.isAssignableFrom(typeClass)) {
                        value = reader.getPrimitiveObject(itemName);
                        if (value instanceof Number) {
                            method.invoke(rsp, (Number)value);
                            continue;
                        }
                        if (!isCheckJsonType || value == null) continue;
                        throw new AlipayApiException(itemName + " is not a Number");
                    }
                    if (Date.class.isAssignableFrom(typeClass)) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        format.setTimeZone(TimeZone.getTimeZone("GMT+8"));
                        Object value2 = reader.getPrimitiveObject(itemName);
                        if (!(value2 instanceof String)) continue;
                        method.invoke(rsp, format.parse(value2.toString()));
                        continue;
                    }
                    if (List.class.isAssignableFrom(typeClass)) {
                        Class subType;
                        List<?> listObjs;
                        ParameterizedType paramType;
                        Type[] genericTypes;
                        Type fieldType = field2.getGenericType();
                        if (!(fieldType instanceof ParameterizedType) || (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) == null || genericTypes.length <= 0 || !(genericTypes[0] instanceof Class) || (listObjs = reader.getListObjects(listName, itemName, subType = (Class)genericTypes[0])) == null) continue;
                        method.invoke(rsp, listObjs);
                        continue;
                    }
                    Object obj = reader.getObject(itemName, typeClass);
                    if (obj == null) continue;
                    method.invoke(rsp, obj);
                }
            }
        }
        catch (Exception e) {
            throw new AlipayApiException(e);
        }
        return rsp;
    }

    private static Field tryGetFieldWithoutExp(Class<?> clazz, String itemName) {
        try {
            return clazz.getDeclaredField(itemName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static <T> Method tryGetSetMethod(Class<T> clazz, Field field, String methodName) {
        try {
            return clazz.getDeclaredMethod(methodName, field.getType());
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        baseFields.add("code");
        baseFields.add("msg");
        baseFields.add("subCode");
        baseFields.add("subMsg");
        baseFields.add("body");
        baseFields.add("params");
        baseFields.add("success");
        excludeFields.add("errorCode");
        overideFields.add("code");
        overideFields.add("msg");
    }
}

