/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api;

import shade.com.alipay.api.AlipayApiException;
import shade.com.alipay.api.SignChecker;
import shade.com.alipay.api.internal.util.AlipaySignature;

public class DefaultSignChecker
implements SignChecker {
    private String alipayPublicKey;

    public DefaultSignChecker(String alipayPublicKey) {
        this.alipayPublicKey = alipayPublicKey;
    }

    @Override
    public boolean check(String sourceContent, String signature, String signType, String charset) {
        boolean success = false;
        try {
            success = AlipaySignature.rsaCheck(sourceContent, signature, this.alipayPublicKey, charset, signType);
        }
        catch (AlipayApiException e) {
            throw new RuntimeException(e);
        }
        return success;
    }

    @Override
    public boolean checkCert(String sourceContent, String signature, String signType, String charset, String publicKey) {
        boolean success = false;
        try {
            success = AlipaySignature.rsaCheck(sourceContent, signature, publicKey, charset, signType);
        }
        catch (AlipayApiException e) {
            throw new RuntimeException(e);
        }
        return success;
    }

    public String getAlipayPublicKey() {
        return this.alipayPublicKey;
    }

    public void setAlipayPublicKey(String alipayPublicKey) {
        this.alipayPublicKey = alipayPublicKey;
    }
}

