/*
 * Decompiled with CFR 0.152.
 */
package shade.com.alipay.api;

import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import shade.com.alipay.api.AbstractAlipayClient;
import shade.com.alipay.api.AlipayApiException;
import shade.com.alipay.api.AlipayConfig;
import shade.com.alipay.api.CertAlipayRequest;
import shade.com.alipay.api.Decryptor;
import shade.com.alipay.api.DefaultDecryptor;
import shade.com.alipay.api.DefaultEncryptor;
import shade.com.alipay.api.DefaultSignChecker;
import shade.com.alipay.api.DefaultSigner;
import shade.com.alipay.api.Encryptor;
import shade.com.alipay.api.SignChecker;
import shade.com.alipay.api.Signer;
import shade.com.alipay.api.internal.util.StringUtils;

public class DefaultAlipayClient
extends AbstractAlipayClient {
    private String privateKey;
    private String encryptKey;
    private String alipayPublicKey;
    private Signer signer;
    private SignChecker signChecker;
    private Encryptor encryptor;
    private Decryptor decryptor;
    private X509Certificate cert;
    private ConcurrentHashMap<String, X509Certificate> alipayPublicCertMap;

    public DefaultAlipayClient(AlipayConfig alipayConfig) throws AlipayApiException {
        super(alipayConfig.getServerUrl(), alipayConfig.getAppId(), alipayConfig.getFormat(), alipayConfig.getCharset(), alipayConfig.getSignType(), alipayConfig.getAppCertPath(), alipayConfig.getAppCertContent(), alipayConfig.getAlipayPublicCertPath(), alipayConfig.getAlipayPublicCertContent(), alipayConfig.getRootCertPath(), alipayConfig.getRootCertContent(), alipayConfig.getProxyHost(), alipayConfig.getProxyPort(), alipayConfig.getEncryptType());
        this.privateKey = alipayConfig.getPrivateKey();
        this.signer = new DefaultSigner(alipayConfig.getPrivateKey());
        this.encryptor = new DefaultEncryptor(alipayConfig.getEncryptKey());
        this.decryptor = new DefaultDecryptor(alipayConfig.getEncryptKey());
        if (!StringUtils.isEmpty(alipayConfig.getAlipayPublicKey())) {
            this.alipayPublicKey = alipayConfig.getAlipayPublicKey();
            this.signChecker = new DefaultSignChecker(alipayConfig.getAlipayPublicKey());
        }
        this.setHeaders(alipayConfig.getCustomHeaders());
        this.setConnectTimeout(alipayConfig.getConnectTimeout());
        this.setReadTimeout(alipayConfig.getReadTimeout());
        this.setMaxIdleConnections(alipayConfig.getMaxIdleConnections());
        this.setKeepAliveDuration(alipayConfig.getKeepAliveDuration());
        this.setCustomizedHttpClient(alipayConfig.getCustomizedHttpClient());
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey) {
        super(serverUrl, appId, null, null, null);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format) {
        super(serverUrl, appId, format, null, null);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format, String charset) {
        super(serverUrl, appId, format, charset, null);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format, String charset, String alipayPublicKey) {
        super(serverUrl, appId, format, charset, null);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.alipayPublicKey = alipayPublicKey;
        this.signChecker = new DefaultSignChecker(alipayPublicKey);
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format, String charset, String alipayPublicKey, String signType) {
        super(serverUrl, appId, format, charset, signType);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.alipayPublicKey = alipayPublicKey;
        this.signChecker = new DefaultSignChecker(alipayPublicKey);
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format, String charset, String alipayPublicKey, String signType, String proxyHost, int proxyPort) {
        super(serverUrl, appId, format, charset, signType, proxyHost, proxyPort);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.alipayPublicKey = alipayPublicKey;
        this.signChecker = new DefaultSignChecker(alipayPublicKey);
    }

    public DefaultAlipayClient(String serverUrl, String appId, String privateKey, String format, String charset, String alipayPublicKey, String signType, String encryptKey, String encryptType) {
        super(serverUrl, appId, format, charset, signType, encryptType);
        this.privateKey = privateKey;
        this.signer = new DefaultSigner(privateKey);
        this.alipayPublicKey = alipayPublicKey;
        this.signChecker = new DefaultSignChecker(alipayPublicKey);
        this.encryptor = new DefaultEncryptor(encryptKey);
        this.decryptor = new DefaultDecryptor(encryptKey);
    }

    public DefaultAlipayClient(CertAlipayRequest certAlipayRequest) throws AlipayApiException {
        super(certAlipayRequest.getServerUrl(), certAlipayRequest.getAppId(), certAlipayRequest.getFormat(), certAlipayRequest.getCharset(), certAlipayRequest.getSignType(), certAlipayRequest.getCertPath(), certAlipayRequest.getCertContent(), certAlipayRequest.getAlipayPublicCertPath(), certAlipayRequest.getAlipayPublicCertContent(), certAlipayRequest.getRootCertPath(), certAlipayRequest.getRootCertContent(), certAlipayRequest.getProxyHost(), certAlipayRequest.getProxyPort(), certAlipayRequest.getEncryptType());
        this.privateKey = certAlipayRequest.getPrivateKey();
        this.signer = new DefaultSigner(certAlipayRequest.getPrivateKey());
        this.encryptor = new DefaultEncryptor(certAlipayRequest.getEncryptor());
        this.decryptor = new DefaultDecryptor(certAlipayRequest.getEncryptor());
    }

    public static Builder builder(String serverUrl, String appId, String privateKey) {
        return new Builder(serverUrl, appId, privateKey);
    }

    @Override
    public Signer getSigner() {
        return this.signer;
    }

    @Override
    public SignChecker getSignChecker() {
        return this.signChecker;
    }

    @Override
    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    @Override
    public Decryptor getDecryptor() {
        return this.decryptor;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public ConcurrentHashMap<String, X509Certificate> getAlipayPublicCertMap() {
        return this.alipayPublicCertMap;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        if (this.signer == null) {
            this.signer = new DefaultSigner(privateKey);
        }
    }

    public void setEncryptKey(String encryptKey) {
        this.encryptKey = encryptKey;
        if (this.encryptor == null) {
            this.encryptor = new DefaultEncryptor(encryptKey);
        }
        if (this.decryptor == null) {
            this.decryptor = new DefaultDecryptor(encryptKey);
        }
    }

    public void setAlipayPublicKey(String alipayPublicKey) {
        this.alipayPublicKey = alipayPublicKey;
        if (this.signChecker == null) {
            this.signChecker = new DefaultSignChecker(alipayPublicKey);
        }
    }

    public static class Builder {
        private DefaultAlipayClient client;

        Builder(String serverUrl, String appId, String privateKey) {
            this.client = new DefaultAlipayClient(serverUrl, appId, privateKey);
        }

        public DefaultAlipayClient build() {
            return this.client;
        }

        public Builder prodCode(String prodCode) {
            this.client.setProdCode(prodCode);
            return this;
        }

        public Builder format(String format) {
            this.client.setFormat(format);
            return this;
        }

        public Builder signType(String signType) {
            this.client.setSignType(signType);
            return this;
        }

        public Builder encryptType(String encryptType) {
            this.client.setEncryptType(encryptType);
            return this;
        }

        public Builder encryptKey(String encryptKey) {
            this.client.setEncryptKey(encryptKey);
            return this;
        }

        public Builder alipayPublicKey(String alipayPublicKey) {
            this.client.setAlipayPublicKey(alipayPublicKey);
            return this;
        }

        public Builder charset(String charset) {
            this.client.setCharset(charset);
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.client.setConnectTimeout(connectTimeout);
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.client.setReadTimeout(readTimeout);
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.client.setProxyHost(proxyHost);
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.client.setProxyPort(proxyPort);
            return this;
        }

        public Builder cert(X509Certificate cert) {
            this.client.setCert(cert);
            return this;
        }

        public Builder alipayPublicCertMap(ConcurrentHashMap<String, X509Certificate> alipayPublicCertMap) {
            this.client.setAlipayPublicCertMap(alipayPublicCertMap);
            return this;
        }
    }
}

