package cn.dalgen.mybatis.gen.utils;

import java.util.List;

import cn.dalgen.mybatis.gen.enums.SystemEnum;
import org.apache.commons.lang.enums.EnumUtils;

/**
 * 获取系统信息
 * <p/>
 *
 * @author bangis.wangdf
 * @date 16/4/16.09:44
 */
public class SysUtil {
    public static SystemEnum getSystem() {
        String os = System.getProperty("os.name").toLowerCase();
        final List<SystemEnum> enumList = EnumUtils.getEnumList(SystemEnum.class);
        for (SystemEnum systemEnum : enumList) {
            if (os.contains(systemEnum.getCode())) {
                return systemEnum;
            }
        }
        throw new RuntimeException("不支持的操作系统" + os);
    }
}
