/*
 * Decompiled with CFR 0.152.
 */
package wiki.primo.generator.mybatis.plus.config.rules;

import org.apache.commons.lang.StringUtils;

public enum NamingStrategy {
    nochange,
    underline_to_camel,
    remove_prefix,
    remove_prefix_and_camel;


    public static String underlineToCamel(String name) {
        String[] camels;
        if (StringUtils.isEmpty((String)name)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String camel : camels = name.toLowerCase().split("_")) {
            if (StringUtils.isEmpty((String)camel)) continue;
            if (result.length() == 0) {
                result.append(camel);
                continue;
            }
            result.append(NamingStrategy.capitalFirst(camel));
        }
        return result.toString();
    }

    public static String removePrefix(String name) {
        if (StringUtils.isBlank((String)name)) {
            return "";
        }
        int idx = name.indexOf("_");
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public static String removePrefix(String name, String prefix) {
        if (StringUtils.isBlank((String)name)) {
            return "";
        }
        if (StringUtils.isEmpty((String)prefix)) {
            return name;
        }
        int idx = name.indexOf("_");
        if (name.toLowerCase().matches("^" + prefix.toLowerCase() + ".*")) {
            idx = prefix.length() - 1;
        }
        if (idx == -1) {
            return name;
        }
        return name.substring(idx + 1);
    }

    public static String removePrefixAndCamel(String name, String tablePrefix) {
        return NamingStrategy.underlineToCamel(NamingStrategy.removePrefix(name, tablePrefix));
    }

    public static String capitalFirst(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return "";
        }
        char[] array = name.toCharArray();
        if (NamingStrategy.isLowerCase(array[0])) {
            array[0] = (char)(array[0] - 32);
        }
        return String.valueOf(array);
    }

    public static boolean isUpperCase(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }
}

