/*
 * Decompiled with CFR 0.152.
 */
package wiki.primo.generator.mybatis.plus.config.constant;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;
import wiki.primo.generator.mybatis.plus.config.constant.ConstVal;
import wiki.primo.generator.mybatis.plus.config.external.ExtConfig;
import wiki.primo.generator.mybatis.plus.config.external.PackageConfig;
import wiki.primo.generator.mybatis.plus.config.external.TemplateConfig;
import wiki.primo.generator.mybatis.plus.util.PackageUtils;

public class ConfigConstant {
    private static Log log = new SystemStreamLog();
    private String packageInfoKey;
    private String pathInfoKey;
    private String outputFilesRuleValue;
    private String packageValue;
    private String templatePath;
    private Boolean fileOverride = true;

    public static void initTableConstant(PackageConfig config, TemplateConfig template) {
        ConfigConstant constant = new ConfigConstant("Entity", "entity_path", File.separator + "%s.java", PackageUtils.joinPackage(config.getParent(), config.getEntity()), template.getEntity());
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("Mapper", "mapper_path", File.separator + "%sMapper.java", PackageUtils.joinPackage(config.getParent(), config.getMapper()), template.getMapper());
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("Xml", "xml_path", File.separator + "%sMapper.xml", PackageUtils.joinPackage(config.getParent(), config.getXml()), template.getXml());
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("Service", "serivce_path", File.separator + "I%sService.java", PackageUtils.joinPackage(config.getParent(), config.getService()), template.getService());
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("ServiceImpl", "serviceimpl_path", File.separator + "%sServiceImpl.java", PackageUtils.joinPackage(config.getParent(), config.getServiceImpl()), template.getServiceImpl());
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("Controller", "controller_path", File.separator + "%sController.java", PackageUtils.joinPackage(config.getParent(), config.getController()), template.getController());
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("QueryBo", "query_path", File.separator + "%sQueryBo.java", PackageUtils.joinPackage(config.getParent(), config.getQuery()), template.getQuery());
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("ServiceExt", "serivce_ext_path", File.separator + "I%sServiceExt.java", PackageUtils.joinPackage(config.getParent(), config.getServiceExt()), template.getServiceExt());
        constant.setFileOverride(false);
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("ServiceExtImpl", "service_ext_impl_path", File.separator + "%sServiceExtImpl.java", PackageUtils.joinPackage(config.getParent(), config.getServiceExtImpl()), template.getServiceExtImpl());
        constant.setFileOverride(false);
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("EntityReq", "entity_req_path", File.separator + "%sReq.java", PackageUtils.joinPackage(config.getParent(), config.getEntityReq()), template.getEntityReq());
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("EntityResp", "entity_resp_path", File.separator + "%sResp.java", PackageUtils.joinPackage(config.getParent(), config.getEntityResp()), template.getEntityResp());
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("PageVOReq", "page_vo_req", File.separator + "%s" + "PageVOReq" + ".java", PackageUtils.joinPackage(config.getParent(), config.getPageVoReq()), "/template/domain/vo/req/page/page_vo_req.java.vm");
        ConstVal.configConstantList.add(constant);
        constant = new ConfigConstant("EntityVOReq", "entity_vo_req", File.separator + "%s" + "EntityVOReq" + ".java", PackageUtils.joinPackage(config.getParent(), config.getEntityVoReq()), "/template/domain/vo/req/entity_vo_req.java.vm");
        ConstVal.configConstantList.add(constant);
    }

    public static void initOneConstant(PackageConfig config, ExtConfig extConfig) {
        log.info((CharSequence)("\u914d\u7f6e\u7684\u6269\u5c55\u6570\u636e\uff1a" + extConfig));
        ConfigConstant constant = new ConfigConstant("ResultCodeEnum", "result_code_enum", File.separator + "ResultCodeEnum.java", PackageUtils.joinPackage(config.getParent(), "enums"), "/template/result_code_enum.java.vm");
        constant.setFileOverride(extConfig.getBuildSwitchConfig().getResultCodeEnum());
        ConstVal.oneConfigConstantList.add(constant);
        constant = new ConfigConstant("ResultModel", "result_model", File.separator + "ResultModel.java", PackageUtils.joinPackage(config.getParent(), "result"), "/template/result_model.java.vm");
        constant.setFileOverride(extConfig.getBuildSwitchConfig().getResultModel());
        ConstVal.oneConfigConstantList.add(constant);
        constant = new ConfigConstant("MybatisPlusConfig", "mybatis_plus_config", File.separator + "MybatisPlusConfig.java", PackageUtils.joinPackage(config.getParent(), "config"), "/template/config/mybatis_plus_config.java.vm");
        constant.setFileOverride(extConfig.getBuildSwitchConfig().getMybatisPlusConfig());
        ConstVal.oneConfigConstantList.add(constant);
        constant = new ConfigConstant("DruidConfig", "druid_config", File.separator + "DruidConfig.java", PackageUtils.joinPackage(config.getParent(), "config"), "/template/config/druid_config.java.vm");
        constant.setFileOverride(extConfig.getBuildSwitchConfig().getDruid());
        ConstVal.oneConfigConstantList.add(constant);
        constant = new ConfigConstant("PageVOResp", "page_vo_resp", File.separator + "PageVOResp.java", PackageUtils.joinPackage(config.getParent(), config.getPageVoResp()), "/template/domain/vo/resp/page_vo_resp.java.vm");
        constant.setFileOverride(true);
        ConstVal.oneConfigConstantList.add(constant);
    }

    public ConfigConstant(String packageInfoKey, String pathInfoKey, String outputFilesRuleValue, String packageValue, String templatePath) {
        this.packageInfoKey = packageInfoKey;
        this.pathInfoKey = pathInfoKey;
        this.outputFilesRuleValue = outputFilesRuleValue;
        this.packageValue = packageValue;
        this.templatePath = templatePath;
    }

    public String getPackageInfoKey() {
        return this.packageInfoKey;
    }

    public String getPathInfoKey() {
        return this.pathInfoKey;
    }

    public String getOutputFilesRuleValue() {
        return this.outputFilesRuleValue;
    }

    public String getPackageValue() {
        return this.packageValue;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public Boolean getFileOverride() {
        return this.fileOverride;
    }

    public void setFileOverride(Boolean fileOverride) {
        this.fileOverride = fileOverride;
    }
}

