/*
 * Decompiled with CFR 0.152.
 */
package wiki.primo.generator.mybatis.plus;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import wiki.primo.generator.mybatis.plus.AbstractGenerateMojo;
import wiki.primo.generator.mybatis.plus.builder.ConfigBuilder;
import wiki.primo.generator.mybatis.plus.builder.page.ControllerMenuBuilder;
import wiki.primo.generator.mybatis.plus.builder.page.ControllerPageBuilder;
import wiki.primo.generator.mybatis.plus.builder.page.PageFieldBuilder;
import wiki.primo.generator.mybatis.plus.builder.po.TableFieldPO;
import wiki.primo.generator.mybatis.plus.builder.po.TableInfoPO;
import wiki.primo.generator.mybatis.plus.config.constant.ConfigConstant;
import wiki.primo.generator.mybatis.plus.config.constant.ConstVal;
import wiki.primo.generator.mybatis.plus.util.FileUtils;
import wiki.primo.generator.mybatis.plus.util.StringUtils;

@Mojo(name="code", threadSafe=true)
public class GenerateMojo
extends AbstractGenerateMojo {
    private ConfigBuilder config;
    private VelocityEngine engine;
    private Map<String, String> classOutputFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"==========================\u51c6\u5907\u751f\u6210\u6587\u4ef6...==========================");
        try {
            this.config = this.initConfig();
            this.initOutputFiles();
            this.mkdirs(this.config.getPathInfo());
            Map<String, VelocityContext> ctxData = this.loadJavaData(this.config);
            for (Map.Entry<String, VelocityContext> ctx : ctxData.entrySet()) {
                this.batchOutput(ctx.getKey(), ctx.getValue(), ConstVal.configConstantList);
            }
            VelocityContext velocityContext = this.commonData(this.config);
            this.batchOutput("", velocityContext, ConstVal.oneConfigConstantList);
            List<ControllerPageBuilder> controllerPageBuilders = this.loadPageData(this.config);
            if (this.config.getFtlConfig().getOpen().booleanValue()) {
                this.batchOutput(controllerPageBuilders);
                Resource[] resources = new PathMatchingResourcePatternResolver().getResources("classpath:template/page/static/**/*");
                this.log.info((CharSequence)("\u83b7\u53d6\u7684resources\u9759\u6001\u6587\u4ef6\u6570\u91cf:" + resources.length));
                for (Resource resource : resources) {
                    if (org.apache.commons.lang.StringUtils.isEmpty((String)resource.getFilename())) {
                        this.log.info((CharSequence)("\u83b7\u53d6\u7684\u662f\u76ee\u5f55\uff1a" + resource.getFilename()));
                        continue;
                    }
                    String resourcePath = resource.getURL().getFile();
                    String saveDir = "src" + File.separator + "main" + File.separator + "resources" + File.separator + resourcePath.substring(resourcePath.indexOf("static"));
                    String savePath = saveDir.substring(0, saveDir.lastIndexOf(File.separator));
                    this.createPath(savePath);
                    InputStream inputStream = resource.getInputStream();
                    byte[] getData = FileUtils.readInputStream(inputStream);
                    File file = new File(saveDir);
                    FileOutputStream fos = new FileOutputStream(file);
                    fos.write(getData);
                    fos.close();
                    inputStream.close();
                    this.log.info((CharSequence)("\u8def\u5f84\uff1a" + savePath + "\uff0c\u4e0b\u8f7d\u9759\u6001\u6587\u4ef6\u3010" + resourcePath + "\u3011\u6210\u529f\uff0c\u4fdd\u5b58\u8def\u5f84\uff1a" + saveDir + ",\u6587\u4ef6\u540d\uff1a" + resource.getFilename()));
                }
            }
            if (this.isOpen()) {
                try {
                    String osName = System.getProperty("os.name");
                    if (osName != null) {
                        if (osName.contains("Mac")) {
                            Runtime.getRuntime().exec("open " + this.getOutputDir());
                        } else if (osName.contains("Windows")) {
                            Runtime.getRuntime().exec("cmd /c start " + this.getOutputDir());
                        } else {
                            this.log.info((CharSequence)("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + this.getOutputDir()));
                        }
                    }
                }
                catch (IOException e) {
                    this.log.error((CharSequence)"[GenerateMojo->execute]\u6253\u5f00\u8f93\u51fa\u76ee\u5f55\u5f02\u5e38", (Throwable)e);
                }
            }
            this.log.info((CharSequence)"==========================\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff01\uff01\uff01==========================");
        }
        catch (Exception e) {
            this.log.error((CharSequence)"==========================\u6587\u4ef6\u751f\u6210\u5f02\u5e38\uff01\uff01\uff01==========================", (Throwable)e);
        }
    }

    private List<ControllerPageBuilder> loadPageData(ConfigBuilder config) {
        ArrayList<ControllerPageBuilder> controllerPageBuilders = new ArrayList<ControllerPageBuilder>();
        List<TableInfoPO> tableList = config.getTableInfoList();
        for (TableInfoPO tableInfo : tableList) {
            ControllerPageBuilder controllerPageBuilder = new ControllerPageBuilder();
            controllerPageBuilder.setModuleName(config.getPackageInfo().getOrDefault("ModuleName", ""));
            ControllerMenuBuilder controllerMenuBuilder = new ControllerMenuBuilder();
            controllerMenuBuilder.setName(tableInfo.getName());
            if (org.apache.commons.lang.StringUtils.isEmpty((String)controllerPageBuilder.getModuleName())) {
                controllerMenuBuilder.setUrl("/" + tableInfo.getEntityName().toLowerCase() + "/tables");
            } else {
                controllerMenuBuilder.setUrl("/" + controllerPageBuilder.getModuleName().toLowerCase() + "/" + TableInfoPO.strConvertLowerCamel(tableInfo.getEntityName()) + "/tables");
            }
            controllerPageBuilder.setControllerMenuBuilder(controllerMenuBuilder);
            controllerPageBuilder.setTemplateFilePath(config.getFtlConfig().getTableTemplatePath());
            controllerPageBuilder.setSaveFilePath(this.getOutputResourcesDir() + config.getFtlConfig().getTablePath());
            controllerPageBuilder.setSaveFilePathName(TableInfoPO.strConvertLowerCamel(tableInfo.getEntityName()) + ".ftl");
            controllerPageBuilder.setTableInfoPO(tableInfo);
            ArrayList<PageFieldBuilder> fieldResps = new ArrayList<PageFieldBuilder>();
            for (TableFieldPO field : tableInfo.getFields()) {
                Integer length;
                PageFieldBuilder pageFieldBuilder = new PageFieldBuilder();
                pageFieldBuilder.setJavaName(field.getPropertyName());
                pageFieldBuilder.setJavaType(field.getPropertyType());
                pageFieldBuilder.setFieldName(field.getName());
                pageFieldBuilder.setFieldType(field.getType());
                pageFieldBuilder.setFieldDescribe(field.getComment());
                pageFieldBuilder.setMajorKey(field.isKeyFlag());
                pageFieldBuilder.setCanFuzzy(false);
                if (field.getType().startsWith("varchar") && (length = this.getMaxLength(field.getType())) > 0 && length <= 128) {
                    pageFieldBuilder.setCanFuzzy(true);
                }
                pageFieldBuilder.setMaxLength(this.getMaxLength(field.getType()));
                fieldResps.add(pageFieldBuilder);
            }
            controllerPageBuilder.setFieldResps(fieldResps);
            controllerPageBuilders.add(controllerPageBuilder);
        }
        return controllerPageBuilders;
    }

    public Integer getMaxLength(String jdbcType) {
        if (org.apache.commons.lang.StringUtils.isEmpty((String)jdbcType)) {
            return 0;
        }
        if (jdbcType.startsWith("json")) {
            return 102400;
        }
        if (jdbcType.startsWith("text")) {
            return 102400;
        }
        if (jdbcType.startsWith("datetime")) {
            return 32;
        }
        Integer length = StringUtils.getNumber(jdbcType);
        if (length == null) {
            this.log.warn((CharSequence)("\u672a\u5339\u914d\u5230\u5177\u4f53\u7684\u6570\u636e\u957f\u5ea6\uff0c\u53ef\u5bf9\u7ef4\u62a4\u8005\u8fdb\u884c\u53cd\u9988\u3002jdbcType=" + jdbcType));
            return 0;
        }
        return length;
    }

    private Map<String, VelocityContext> loadJavaData(ConfigBuilder config) {
        List<TableInfoPO> tableList = config.getTableInfoList();
        Map<String, String> packageInfo = config.getPackageInfo();
        HashMap<String, VelocityContext> ctxData = new HashMap<String, VelocityContext>();
        String superEntityClass = this.getSuperClassName(config.getSuperEntityClass());
        String superMapperClass = this.getSuperClassName(config.getSuperMapperClass());
        String superServiceClass = this.getSuperClassName(config.getSuperServiceClass());
        String superServiceImplClass = this.getSuperClassName(config.getSuperServiceImplClass());
        String superControllerClass = this.getSuperClassName(config.getSuperControllerClass());
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        for (TableInfoPO tableInfo : tableList) {
            VelocityContext ctx = new VelocityContext();
            ctx.put("package", packageInfo);
            ctx.put("table", (Object)tableInfo);
            ctx.put("entity", (Object)tableInfo.getEntityName());
            ctx.put("addTableName", (Object)(!tableInfo.getEntityName().toLowerCase().equals(tableInfo.getName().toLowerCase()) ? 1 : 0));
            ctx.put("idGenType", (Object)config.getIdType());
            ctx.put("superEntityClassPackage", (Object)config.getSuperEntityClass());
            ctx.put("superEntityClass", (Object)superEntityClass);
            ctx.put("superMapperClassPackage", (Object)config.getSuperMapperClass());
            ctx.put("superMapperClass", (Object)superMapperClass);
            ctx.put("superServiceClassPackage", (Object)config.getSuperServiceClass());
            ctx.put("superServiceClass", (Object)superServiceClass);
            ctx.put("superServiceImplClassPackage", (Object)config.getSuperServiceImplClass());
            ctx.put("superServiceImplClass", (Object)superServiceImplClass);
            ctx.put("superControllerClassPackage", (Object)config.getSuperControllerClass());
            ctx.put("superControllerClass", (Object)superControllerClass);
            ctx.put("enableCache", (Object)this.isEnableCache());
            ctx.put("author", (Object)this.getAuthor());
            ctx.put("activeRecord", (Object)this.isActiveRecord());
            ctx.put("date", (Object)date);
            ctxData.put(tableInfo.getEntityName(), ctx);
        }
        return ctxData;
    }

    private VelocityContext commonData(ConfigBuilder config) {
        Map<String, String> packageInfo = config.getPackageInfo();
        String superEntityClass = this.getSuperClassName(config.getSuperEntityClass());
        String superMapperClass = this.getSuperClassName(config.getSuperMapperClass());
        String superServiceClass = this.getSuperClassName(config.getSuperServiceClass());
        String superServiceImplClass = this.getSuperClassName(config.getSuperServiceImplClass());
        String superControllerClass = this.getSuperClassName(config.getSuperControllerClass());
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        VelocityContext ctx = new VelocityContext();
        ctx.put("package", packageInfo);
        ctx.put("idGenType", (Object)config.getIdType());
        ctx.put("superEntityClassPackage", (Object)config.getSuperEntityClass());
        ctx.put("superEntityClass", (Object)superEntityClass);
        ctx.put("superMapperClassPackage", (Object)config.getSuperMapperClass());
        ctx.put("superMapperClass", (Object)superMapperClass);
        ctx.put("superServiceClassPackage", (Object)config.getSuperServiceClass());
        ctx.put("superServiceClass", (Object)superServiceClass);
        ctx.put("superServiceImplClassPackage", (Object)config.getSuperServiceImplClass());
        ctx.put("superServiceImplClass", (Object)superServiceImplClass);
        ctx.put("superControllerClassPackage", (Object)config.getSuperControllerClass());
        ctx.put("superControllerClass", (Object)superControllerClass);
        ctx.put("enableCache", (Object)this.isEnableCache());
        ctx.put("author", (Object)this.getAuthor());
        ctx.put("activeRecord", (Object)this.isActiveRecord());
        ctx.put("date", (Object)date);
        return ctx;
    }

    private String getSuperClassName(String classPath) {
        if (org.apache.commons.lang.StringUtils.isBlank((String)classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(".") + 1);
    }

    private void mkdirs(Map<String, String> pathInfo) {
        for (Map.Entry<String, String> entry : pathInfo.entrySet()) {
            this.createPath(entry.getValue());
        }
    }

    private void createPath(String value) {
        boolean result;
        File dir = new File(value);
        if (!dir.exists() && (result = dir.mkdirs())) {
            this.log.info((CharSequence)("\u521b\u5efa\u76ee\u5f55\uff1a [" + value + "]\u6210\u529f"));
        }
    }

    private void initOutputFiles() {
        this.classOutputFiles = new HashMap<String, String>();
        Map<String, String> pathInfo = this.config.getPathInfo();
        for (List<ConfigConstant> constants : ConstVal.getConfigConstantList()) {
            for (ConfigConstant constant : constants) {
                this.classOutputFiles.put(constant.getPackageInfoKey(), pathInfo.get(constant.getPathInfoKey()) + constant.getOutputFilesRuleValue());
            }
        }
    }

    private void batchOutput(String entityName, VelocityContext context, List<ConfigConstant> constants) {
        try {
            for (ConfigConstant constant : constants) {
                String file = String.format(this.classOutputFiles.get(constant.getPackageInfoKey()), entityName);
                if (!this.isCreate(file) || !this.isCreate(file, constant)) continue;
                this.vmToFile(context, constant.getTemplatePath(), file);
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)"\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            this.log.error((CharSequence)"\u521b\u5efa\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void batchOutput(List<ControllerPageBuilder> controllerPageBuilders) {
        try {
            ArrayList<ControllerMenuBuilder> controllerMenuBuilderList = new ArrayList<ControllerMenuBuilder>();
            for (ControllerPageBuilder controllerPageBuilder : controllerPageBuilders) {
                controllerMenuBuilderList.add(controllerPageBuilder.getControllerMenuBuilder());
            }
            for (ControllerPageBuilder controllerPageBuilder : controllerPageBuilders) {
                this.createPath(controllerPageBuilder.getSaveFilePath());
                String file = controllerPageBuilder.getSaveFilePath() + controllerPageBuilder.getSaveFilePathName();
                if (!this.isCreate(file)) continue;
                String temp = controllerPageBuilder.getTemplateFilePath();
                VelocityContext context = new VelocityContext();
                context.put("tablesData", (Object)controllerPageBuilder);
                context.put("tablesMenuList", controllerMenuBuilderList);
                this.vmToFile(context, temp, file);
            }
        }
        catch (IOException e) {
            this.log.error((CharSequence)"\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
            e.printStackTrace();
        }
        catch (Exception e) {
            this.log.error((CharSequence)"\u521b\u5efa\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void vmToFile(VelocityContext context, String templatePath, String outputFile) throws Exception {
        VelocityEngine velocity = this.getVelocityEngine();
        Template template = velocity.getTemplate(templatePath, ConstVal.UTF8);
        FileOutputStream fos = new FileOutputStream(outputFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8));
        template.merge((Context)context, (Writer)writer);
        writer.close();
        this.log.info((CharSequence)("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile));
    }

    private VelocityEngine getVelocityEngine() throws Exception {
        if (this.engine == null) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("file.resource.loader.path", "");
            p.setProperty("ISO-8859-1", ConstVal.UTF8);
            p.setProperty("input.encoding", ConstVal.UTF8);
            p.setProperty("output.encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.engine = new VelocityEngine(p);
        }
        return this.engine;
    }

    private boolean isCreate(String filePath) {
        File file = new File(filePath);
        return !file.exists() || this.isFileOverride();
    }

    private boolean isCreate(String filePath, ConfigConstant constant) {
        File file = new File(filePath);
        return !file.exists() || constant.getFileOverride() != false;
    }
}

