/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse;
import software.amazon.awssdk.services.xray.model.TraceSummary;

public class GetTraceSummariesIterable
implements SdkIterable<GetTraceSummariesResponse> {
    private final XRayClient client;
    private final GetTraceSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTraceSummariesIterable(XRayClient client, GetTraceSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetTraceSummariesResponseFetcher();
    }

    public Iterator<GetTraceSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TraceSummary> traceSummaries() {
        Function<GetTraceSummariesResponse, Iterator> getIterator = response -> {
            if (response != null && response.traceSummaries() != null) {
                return response.traceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTraceSummariesResponseFetcher
    implements SyncPageFetcher<GetTraceSummariesResponse> {
        private GetTraceSummariesResponseFetcher() {
        }

        public boolean hasNextPage(GetTraceSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTraceSummariesResponse nextPage(GetTraceSummariesResponse previousPage) {
            if (previousPage == null) {
                return GetTraceSummariesIterable.this.client.getTraceSummaries(GetTraceSummariesIterable.this.firstRequest);
            }
            return GetTraceSummariesIterable.this.client.getTraceSummaries((GetTraceSummariesRequest)((Object)GetTraceSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

