/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MetricType {
    AGGREGATED_RELATIVE_TOTAL_TIME("AggregatedRelativeTotalTime"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MetricType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricType> knownValues() {
        return Stream.of(MetricType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

