/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.auditmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.auditmanager.model.Assessment;
import software.amazon.awssdk.services.auditmanager.model.AuditManagerResponse;
import software.amazon.awssdk.services.auditmanager.model.Role;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssessmentResponse
extends AuditManagerResponse
implements ToCopyableBuilder<Builder, GetAssessmentResponse> {
    private static final SdkField<Assessment> ASSESSMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assessment").getter(GetAssessmentResponse.getter(GetAssessmentResponse::assessment)).setter(GetAssessmentResponse.setter(Builder::assessment)).constructor(Assessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assessment").build()}).build();
    private static final SdkField<Role> USER_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("userRole").getter(GetAssessmentResponse.getter(GetAssessmentResponse::userRole)).setter(GetAssessmentResponse.setter(Builder::userRole)).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userRole").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_FIELD, USER_ROLE_FIELD));
    private final Assessment assessment;
    private final Role userRole;

    private GetAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.assessment = builder.assessment;
        this.userRole = builder.userRole;
    }

    public final Assessment assessment() {
        return this.assessment;
    }

    public final Role userRole() {
        return this.userRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessment());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssessmentResponse)) {
            return false;
        }
        GetAssessmentResponse other = (GetAssessmentResponse)((Object)obj);
        return Objects.equals(this.assessment(), other.assessment()) && Objects.equals(this.userRole(), other.userRole());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssessmentResponse").add("Assessment", (Object)this.assessment()).add("UserRole", (Object)this.userRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assessment": {
                return Optional.ofNullable(clazz.cast(this.assessment()));
            }
            case "userRole": {
                return Optional.ofNullable(clazz.cast(this.userRole()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssessmentResponse, T> g) {
        return obj -> g.apply((GetAssessmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AuditManagerResponse.BuilderImpl
    implements Builder {
        private Assessment assessment;
        private Role userRole;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssessmentResponse model) {
            super(model);
            this.assessment(model.assessment);
            this.userRole(model.userRole);
        }

        public final Assessment.Builder getAssessment() {
            return this.assessment != null ? this.assessment.toBuilder() : null;
        }

        @Override
        public final Builder assessment(Assessment assessment) {
            this.assessment = assessment;
            return this;
        }

        public final void setAssessment(Assessment.BuilderImpl assessment) {
            this.assessment = assessment != null ? assessment.build() : null;
        }

        public final Role.Builder getUserRole() {
            return this.userRole != null ? this.userRole.toBuilder() : null;
        }

        @Override
        public final Builder userRole(Role userRole) {
            this.userRole = userRole;
            return this;
        }

        public final void setUserRole(Role.BuilderImpl userRole) {
            this.userRole = userRole != null ? userRole.build() : null;
        }

        @Override
        public GetAssessmentResponse build() {
            return new GetAssessmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AuditManagerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssessmentResponse> {
        public Builder assessment(Assessment var1);

        default public Builder assessment(Consumer<Assessment.Builder> assessment) {
            return this.assessment((Assessment)((Assessment.Builder)Assessment.builder().applyMutation(assessment)).build());
        }

        public Builder userRole(Role var1);

        default public Builder userRole(Consumer<Role.Builder> userRole) {
            return this.userRole((Role)((Role.Builder)Role.builder().applyMutation(userRole)).build());
        }
    }
}

